% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethno_bayes_consensus.R
\name{ethno_bayes_consensus}
\alias{ethno_bayes_consensus}
\title{Gives a measure of the confidence we can have in the answers in the ethnobotany data.}
\usage{
ethno_bayes_consensus(data, answers = 2, prior_for_answers, prior=-1)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}

\item{answers}{The number of answers available for each question. These are set to '2' because the way the package works at the moment users can have either a '1' or a '0' in the table. It is however, possible to have more.}

\item{prior_for_answers}{A matrix representing the probability of a given use being more likely. If not provided the function assumes a uniform distribution across uses.}

\item{prior}{a prior distribution of probabilities over all answers as a matrix. If this is not provided the function assumes a uniform distribution (prior = -1).}
}
\value{
A matrix, where columns represent plant use categories and rows represent responses per person and plant (matching the data). Each value represents the bayes_consensus that an answer was 'correct' for a particular use, within the cultural consensus framework.
}
\description{
Determine the probability that informant citations for a given use are 'correct' given informant responses to the use category for each plant, an estimate of each person's prior_for_answers with this plant and use, and the number of possible answers about this plant use.
}
\section{Warning}{


Identification for informants and species must be listed by the names 'informant' and 'sp_name' respectively in the data set.
The rest of the columns should all represent separate identified ethnobotany use categories. These data should be populated with counts of uses per informant (should be 0 or 1 values).
}

\examples{

#Use built-in ethnobotany data example
#assign a non-informative prior to prior_for_answers with 'prior_for_answers=0.5'
ethno_bayes_consensus(ethnobotanydata, answers = 2, prior_for_answers = 0.5, prior = -1)

#Generate random dataset of three informants uses for four species

eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant <- sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name <- sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)

#assign a non-informative prior to prior_for_answers
eb_prior_for_answers <- rep(0.5, len = nrow(eb_data))

ethno_bayes_consensus(eb_data, answers = 5, prior_for_answers = eb_prior_for_answers)

}
\references{
Oravecz, Z., Vandekerckhove, J., & Batchelder, W. H. (2014). Bayesian Cultural Consensus Theory. Field Methods, 1525822X13520280. http://doi.org/10.1177/1525822X13520280

Romney, A. K., Weller, S. C., & Batchelder, W. H. (1986). Culture as Consensus: A Theory of Culture and Informant Accuracy. American Anthropologist, 88(2), 313-338.

Alastair Jamieson Lane and Benjamin Grant Purzycki (2016), AnthroTools: Some custom tools for anthropology.
}
\keyword{arith}
\keyword{bayes}
\keyword{bayesian}
\keyword{consensus}
\keyword{ethnobotany}
\keyword{logic}
\keyword{math}
\keyword{methods}
\keyword{misc}
\keyword{survey}
