% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{eulerr}
\alias{eulerr}
\alias{eulerr.data.frame}
\alias{eulerr.default}
\alias{eulerr.matrix}
\title{Area-proportional Euler diagrams}
\usage{
eulerr(sets, ...)

\method{eulerr}{default}(sets, ...)

\method{eulerr}{matrix}(sets, ...)

\method{eulerr}{data.frame}(sets, ...)
}
\arguments{
\item{sets}{Set relationships (see methods (by class) section).}

\item{\dots}{Currently ignored.}
}
\value{
A list object of class 'eulerr' with the following parameters.
  \item{coefficients}{A matrix of x and y coordinates for the centers of the
    circles and their radiuses.}
  \item{original.values}{The set relationships provided by the user.}
  \item{fitted.values}{The set relationships in the solution given by
    \pkg{eulerr}.}
  \item{residuals}{Squared residuals between the original areas and the
    fitted areas.}
  \item{stress}{The stress of the solution, computed as
  squared residuals over the sum of squared residuals.}
}
\description{
eulerr computes eulerr diagrams (a generalization of Venn diagrams) using
numerical optimization to find exact or the optimal approximations
for a input of set relationships.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: A named numeric vector, with
interactions seperated by an ampersand, for instance \code{`A&B` = 10}.
Missing interactions are treated as being 0.

\item \code{matrix}: A matrix of logical vectors with columns representing sets
and rows representing each observation's set relationships (see examples).

\item \code{data.frame}: A data.frame that can be converted to a matrix of logicals
(as in the description above) via \code{\link[base]{as.matrix}}.
}}
\examples{

fit1 <- eulerr(c("A" = 1, "B" = 0.4, "C" = 3, "A&B" = 0.2))

# Same result as above
fit2 <- eulerr(c("A" = 1, "B" = 0.4, "C" = 3,
                 "A&B" = 0.2, "A&C" = 0, "B&C" = 0,
                 "A&B&C" = 0) )

# Using the matrix method
mat <- cbind(A = sample(c(TRUE, TRUE, FALSE), size = 50, replace = TRUE),
             B = sample(c(TRUE, FALSE), size = 50, replace = TRUE))
fit3 <- eulerr(mat)

}
\seealso{
\code{\link{plot.eulerr}}
}

