% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoglm-methods.R
\name{vcov.pseudoglm}
\alias{vcov.pseudoglm}
\title{Compute covariance matrix of regression coefficient estimates}
\usage{
\method{vcov}{pseudoglm}(object, type = "robust", ...)
}
\arguments{
\item{object}{A pseudoglm object, as returned by \link{cumincglm} or
\link{rmeanglm}.}

\item{type}{The method to use for variance estimation; one of "corrected",
"robust", "naive", or "cluster"}

\item{...}{Arguments passed to \link[sandwich]{vcovHC}}
}
\value{
A numeric matrix containing the variance-covariance estimates
}
\description{
Compute covariance matrix of regression coefficient estimates
}
\details{
The "corrected" variance estimate is as described in Overgaard et
  al. (2017) <doi:10.1214/16-AOS1516>, with code adapted from Overgaard's
  Stata program. This method does not handle ties and only has
  marginal benefits in reasonable sample sizes. The default is "robust" which
  uses a sandwich estimator as implemented in the sandwich package. "cluster"
  is another option if you have clustered observations. Finally "naive" uses
  the same method as glm to compute the variance, and is known to be
  anti-conservative. The bootstrap is another recommended option that can be
  implemented using other tools; there is an example in the vignette.
}
\references{
Overgaard, Morten; Parner, Erik Thorlund; Pedersen, Jan.
  Asymptotic theory of generalized estimating equations based on jack-knife
  pseudo-observations. Ann. Statist. 45 (2017), no. 5, 1988--2015.
  <doi:10.1214/16-AOS1516>.
}
\seealso{
\link[sandwich]{vcovHC}
}
