% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_handler.R
\name{+.handler}
\alias{+.handler}
\title{Add handlers to a handlers_list}
\usage{
\method{+}{handler}(e1, e2)
}
\arguments{
\item{e1}{A handler, handler_list or dispatcher object.}

\item{e2}{A handler or handlers_list object.}
}
\value{
Retun a \code{handlers_list} object.
}
\description{
Merge two handler objects or add a handler in a handlers_list or dispatcher objects.
}
\examples{

library(eventr)
library(magrittr)

birth_handler <- handler(type = 'BIRTH', FUN = function(obj, event){
  obj$birth_date <- get_body_attr(event, 'birth_date')
  return(obj)
})

measurement_handler <- handler(type = 'MEASUREMENT', FUN = function(obj, event){

  obj$weight <- get_body_attr(event, 'weight')
  obj$height <- get_body_attr(event, 'height')
  return(obj)

})

death_handler <- handler(type = 'DEATH', FUN = function(obj, event){
  obj$death_date <- get_body_attr(event, 'death_date')
  return(obj)
})

handlers <- birth_handler +
  measurement_handler +
  death_handler

}
