% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fnormgpdcon.r
\name{fnormgpdcon}
\alias{fnormgpdcon}
\alias{lnormgpdcon}
\alias{nlnormgpdcon}
\alias{nlunormgpdcon}
\alias{proflunormgpdcon}
\title{MLE Fitting of Normal Bulk and GPD Tail Extreme Value Mixture Model with Single Continuity Constraint}
\usage{
fnormgpdcon(x, phiu = TRUE, useq = NULL, fixedu = FALSE, pvector = NULL,
  std.err = TRUE, method = "BFGS", control = list(maxit = 10000),
  finitelik = TRUE, ...)

lnormgpdcon(x, nmean = 0, nsd = 1, u = qnorm(0.9, nmean, nsd), xi = 0,
  phiu = TRUE, log = TRUE)

nlnormgpdcon(pvector, x, phiu = TRUE, finitelik = FALSE)

proflunormgpdcon(u, pvector, x, phiu = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = TRUE, ...)

nlunormgpdcon(pvector, u, x, phiu = TRUE, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiu}{probability of being above threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fnormgpd]{fnormgpd}}}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{u}{scalar threshold value}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:fnormgpdcon]{lnormgpdcon}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fnormgpdcon]{nlnormgpdcon}}
  and \code{\link[evmix:fnormgpdcon]{nlunormgpdcon}}. Profile likelihood for single
  threshold given by \code{\link[evmix:fnormgpdcon]{proflunormgpdcon}}. Fitting function
  \code{\link[evmix:fnormgpdcon]{fnormgpdcon}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed threshold, logical\cr
 \code{useq}:      \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold in useq\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{nmean}:     \tab MLE of normal mean\cr
 \code{nsd}:       \tab MLE of normal standard deviation\cr
 \code{u}:         \tab threshold (fixed or MLE)\cr
 \code{sigmau}:    \tab MLE of GPD scale (estimated from other parameters)\cr
 \code{xi}:        \tab MLE of GPD shape\cr
 \code{phiu}:      \tab MLE of tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiu}:   \tab standard error of MLE of tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with normal for bulk distribution upto the threshold and conditional
GPD above threshold with continuity at threshold. With options for profile likelihood estimation for threshold and
fixed threshold approach.
}
\details{
The extreme value mixture model with normal bulk and GPD tail with continuity at threshold is
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for full details, type \code{help fnormgpd}. Only
the different features are outlined below for brevity.

The GPD \code{sigmau} parameter is now specified as function of other parameters, see
help for \code{\link[evmix:normgpdcon]{dnormgpdcon}} for details, type \code{help normgpdcon}.
Therefore, \code{sigmau} should not be included in the parameter vector if initial values
are provided, making the full parameter vector
(\code{nmean}, \code{nsd}, \code{u}, \code{xi}) if threshold is also estimated and
(\code{nmean}, \code{nsd}, \code{xi}) for profile likelihood or fixed threshold approach.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of normal parameters assuming entire population is normal; and
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD shape parameter above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Continuity constraint
fit = fnormgpdcon(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dnormgpdcon(xx, nmean, nsd, u, xi), col="red"))
abline(v = fit$u, col = "red")

# No continuity constraint
fit2 = fnormgpd(x)
with(fit2, lines(xx, dnormgpd(xx, nmean, nsd, u, sigmau, xi), col="blue"))
abline(v = fit2$u, col = "blue")
legend("topleft", c("True Density","No continuity constraint","With continuty constraint"),
  col=c("black", "blue", "red"), lty = 1)

# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fnormgpdcon(x, useq = seq(0, 3, length = 20))
fitfix = fnormgpdcon(x, useq = seq(0, 3, length = 20), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dnormgpdcon(xx, nmean, nsd, u, xi), col="red"))
abline(v = fit$u, col = "red")
with(fitu, lines(xx, dnormgpdcon(xx, nmean, nsd, u, xi), col="purple"))
abline(v = fitu$u, col = "purple")
with(fitfix, lines(xx, dnormgpdcon(xx, nmean, nsd, u, xi), col="darkgreen"))
abline(v = fitfix$u, col = "darkgreen")
legend("topleft", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Behrens, C.N., Lopes, H.F. and Gamerman, D. (2004). Bayesian analysis of extreme
events with threshold estimation. Statistical Modelling. 4(3), 227-244.
}
\seealso{
\code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}};
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{gng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}; \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{ditmgng}}, \code{\link{ditmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{itmgng}},
  \code{\link{itmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{pitmgng}}, \code{\link{pitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{qitmgng}},
  \code{\link{qitmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}},
  \code{\link{ritmgng}}, \code{\link{ritmgng}};
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}; \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}};
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}; \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}};
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{nleuitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{profleuitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}; \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}}
}

