% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRD.R
\name{SRD}
\alias{SRD}
\alias{SRD.default}
\alias{SRD.list}
\alias{plot.SRD}
\title{Compare matrices via Selection Response Decomposition}
\usage{
SRD(cov.x, cov.y, ...)

\method{SRD}{default}(cov.x, cov.y, iterations = 1000, ...)

\method{SRD}{list}(cov.x, cov.y = NULL, iterations = 1000, parallel = FALSE, ...)

\method{plot}{SRD}(x, matrix.label = "", ...)
}
\arguments{
\item{cov.x}{Covariance matrix being compared. cov.x can be a matrix or a list.}

\item{cov.y}{Covariance matrix being compared. Ignored if cov.x is a list.}

\item{...}{additional parameters passed to other methods}

\item{iterations}{Number of random vectors used in comparison}

\item{parallel}{if TRUE computations are done in parallel. Some foreach back-end must be registered, like doParallel or doMC.}

\item{x}{Output from SRD function, used in plotting}

\item{matrix.label}{Plot label}
}
\value{
List of SRD scores means, confidence intervals, standard
deviations, centered means e centered standard deviations

pc1 scored along the pc1 of the mean/SD correlation matrix

model List of linear model results from mean/SD correlation. Quantiles, interval and divergent traits
}
\description{
Based on Random Skewers technique, selection response vectors are
expanded in direct and indirect components by trait and compared via
vector correlations.
}
\details{
Output can be plotted using PlotSRD function
}
\note{
If input is a list, output is a symmetric list array with pairwise comparisons.
}
\examples{
cov.matrix.1 <- cov(matrix(rnorm(30*10), 30, 10))
cov.matrix.2 <- cov(matrix(rnorm(30*10), 30, 10))
colnames(cov.matrix.1) <- colnames(cov.matrix.2) <- sample(letters, 10)
rownames(cov.matrix.1) <- rownames(cov.matrix.2) <- colnames(cov.matrix.1)
srd.output <- SRD(cov.matrix.1, cov.matrix.2)

#lists
m.list <- RandomMatrix(10, 4)
srd.array.result = SRD(m.list)

#divergent traits
colnames(cov.matrix.1)[as.logical(srd.output$model$code)]

#Plot
plot(srd.output)

## For the array generated by SRD(m.list) you must index the idividual positions for plotting:
plot(srd.array.result[1,2][[1]])
plot(srd.array.result[3,4][[1]])

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#SRD(m.list, parallel = TRUE)
}
\references{
Marroig, G., Melo, D., Porto, A., Sebastiao, H., and Garcia, G.
(2011). Selection Response Decomposition (SRD): A New Tool for
Dissecting Differences and Similarities Between Matrices. Evolutionary
Biology, 38(2), 225-241. doi:10.1007/s11692-010-9107-2
}
\seealso{
\code{\link{RandomSkewers}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{RandomSkewers}
\keyword{SRD}
\keyword{selectionresponsedecomposition}
