% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENNreg_cv.R
\name{ENNreg_cv}
\alias{ENNreg_cv}
\title{Hyperparameter tuning for the ENNreg model using cross-validation}
\usage{
ENNreg_cv(
  X,
  y,
  K,
  batch = TRUE,
  folds = NULL,
  Kfold = 5,
  XI,
  RHO,
  nstart = 100,
  c = 1,
  lambda = 0.9,
  eps = NULL,
  nu = 1e-16,
  optimProto = TRUE,
  verbose = TRUE,
  options = list(maxiter = 1000, rel.error = 1e-04, print = 10),
  opt.rmsprop = list(batch_size = 100, epsi = 0.001, rho = 0.9, delta = 1e-08, Dtmax =
    100)
)
}
\arguments{
\item{X}{Input matrix of size n x p, where n is the number of objects and p the number of
attributes.}

\item{y}{Vector of length n containing observations of the response variable.}

\item{K}{Number of prototypes.}

\item{batch}{If TRUE (default), batch learning is used; otherwise, online learning is
used.}

\item{folds}{Vector of length n containing the folds (integers between 1 and Kfold).}

\item{Kfold}{Number of folds (default=5, used only if \code{folds} is not provided).}

\item{XI}{Vector of candidate values for hyperparameter \code{xi}.}

\item{RHO}{Vector of candidate values for hyperparameter \code{rho}.}

\item{nstart}{Number of random starts of the k-means algorithm (default: 100).}

\item{c}{Multiplicative coefficient applied to scale parameter gamma (defaut: 1).}

\item{lambda}{Parameter of the loss function (default=0.9).}

\item{eps}{Parameter of the loss function (if NULL, fixed to 0.01 times the standard
deviation of y).}

\item{nu}{Parameter of the loss function to avoid a division par zero (default=1e-16).}

\item{optimProto}{If TRUE (default), the initial prototypes are optimized.}

\item{verbose}{If TRUE (default) intermediate results are displayed.}

\item{options}{Parameters of the optimization algorithm (see \code{\link{ENNreg}}).}

\item{opt.rmsprop}{Parameters of the RMSprop algorithm (see \code{\link{ENNreg}}).}
}
\value{
A list with three components:
\describe{
\item{xi}{Optimal value of xi.}
\item{rho}{Optimal value of rho.}
\item{RMS}{Matrix of root mean squared error values}.
}
}
\description{
\code{ENNreg_cv} tunes parameters xi and rho of the ENNreg model using cross-validation.
}
\details{
Either the folds (a vector of the same length as y, such that \code{folds[i]} equals the
fold, between 1 and Kfold, containing observation i), or the number of folds must be provided.
Arguments \code{options} and \code{opt.rmsprop} are passed to function \code{\link{ENNreg}}.
}
\examples{
# Boston dataset
\donttest{
library(MASS)
X<-as.matrix(scale(Boston[,1:13]))
y<-Boston[,14]
set.seed(220322)
n<-nrow(Boston)
ntrain<-round(0.7*n)
train <-sample(n,ntrain)
cv<-ENNreg_cv(X=X[train,],y=y[train],K=30,XI=c(0.1,1,10),RHO=c(0.1,1,10))
cv$RMScv
fit <- ENNreg(X[train,],y[train],K=30,xi=cv$xi,rho=cv$rho)
pred<-predict(fit,newdata=X[-train,],yt=y[-train])
print(pred$RMS)
}
}
\references{
Thierry Denoeux. An evidential neural network model for regression based on random fuzzy
numbers. In "Belief functions: Theory and applications (proc. of BELIEF 2022)", pages 57-66,
Springer, 2022.

Thierry Denoeux. Quantifying prediction uncertainty in regression using random fuzzy sets: the ENNreg
model. TechRxiv preprint, 2023b
}
\seealso{
\code{\link{ENNreg}}, \code{\link{ENNreg_holdout}}
}
