% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{make_test_shell}
\alias{make_test_shell}
\title{Make the shell of a \code{test_that} test.}
\usage{
make_test_shell(example_block, desc = "")
}
\arguments{
\item{example_block}{A character vector of the lines in the examples of a
function's documentation.}

\item{desc}{To be the \code{desc} argument of the \code{\link[testthat:test_that]{testthat::test_that()}} call.}
}
\value{
A character vector giving the shell of a test_that function call
testing all of the calls in the example block.
}
\description{
Given a character vector of the examples from a function, create the shell of
a \code{test_that} code block (to be filled in by the user) based upon those
examples.
}
\details{
Assignment lines (lines with '<-') and lines with 'stop()' or 'warning()' are
left alone, others are put in the shell of an 'expect_equal()' statement. See
the examples.
}
\examples{
setwd(tempdir())
if (dir.exists("tempkg")) warning("Do not proceed, you'll mess with your ",
"'tempkg' folder.")
dir.create("tempkg")
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", "exemplar.R", package = "exampletestr"),
"R", overwrite = TRUE)
make_test_shell(extract_examples("exemplar")[[1]])
setwd("..")
filesstrings::RemoveDirs("tempkg")

}
