% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{make_tests_shells_file}
\alias{make_tests_shells_file}
\alias{make_tests_shells_pkg}
\title{Create the shell of a test file.}
\usage{
make_tests_shells_file(r_file_name, pkg_dir = ".", overwrite = FALSE,
  e_e = TRUE)

make_tests_shells_pkg(pkg_dir = ".", overwrite = FALSE, e_e = TRUE)
}
\arguments{
\item{r_file_name}{The name of the \code{.R} file within \code{R/}. There's no need to
specify the file path (as \code{R/x.R}, but you can do this if you want), you
can just use \code{x.R} for whichever file \code{x} it is. You can also omit the \code{.R}
for convenience, however using the wrong case (e.g. \code{.r} when the file
actually has the extension \code{.R}) will produce an error.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). Note that this is the parent directory of R/.}

\item{overwrite}{Overwrite if the test file you're trying to create already
exists?}

\item{e_e}{Set this to \code{FALSE} to prevent anything from being put in the
shell of an \code{expect_equal()} statement.}
}
\value{
The shell of the test file is written into tests/testthat. It has the
same name as the .R file it was created from except it has "test_" tacked
onto the front.
}
\description{
For a given file \code{x.R} in the \code{R/} directory of a package, for each function
defined in that \code{.R} file, \code{make_tests_shells_file} checks if there are
examples for that function detailed in the \code{man/} directory (in a \code{.Rd} file)
and if so creates a shell (skeleton) of a \code{\link[testthat:test_that]{testthat::test_that()}} test based
on those examples via \code{\link[=make_test_shell]{make_test_shell()}}. The created shells are then
written to a file \code{test_x.R} in \code{tests/testthat}.
}
\examples{
setwd(tempdir())
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", c("exemplar.R", "exampletestr.R"),
                      package = "exampletestr"), "R")
devtools::document()
exampletestr::make_tests_shells_file("exemplar")
devtools::document()
exampletestr::make_tests_shells_pkg(overwrite = TRUE)
setwd("..")
filesstrings::dir.remove("tempkg")

}
