% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{mark_progress}
\alias{mark_progress}
\title{Mark survey progress}
\usage{
mark_progress(
  x,
  min_progress = 100,
  id_col = "ResponseId",
  finished_col = "Finished",
  progress_col = "Progress",
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{min_progress}{Amount of progress considered acceptable to include.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{finished_col}{Column name for whether survey was completed.}

\item{progress_col}{Column name for percentage of survey completed.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes a column marking rows
that have incomplete progress.
For a function that checks for these rows, use \code{\link[=check_progress]{check_progress()}}.
For a function that excludes these rows, use \code{\link[=exclude_progress]{exclude_progress()}}.
}
\description{
The \code{mark_progress()} function creates a column labeling
rows that have incomplete progress.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The default requires 100\% completion, but lower levels of completion
maybe acceptable and can be allowed by specifying the \code{min_progress}
argument.
The finished column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that have incomplete progress.
}
\examples{
# Mark rows with incomplete progress
data(qualtrics_text)
df <- mark_progress(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  mark_progress()

# Include a lower acceptable completion percentage
df <- qualtrics_numeric \%>\%
  exclude_preview() \%>\%
  mark_progress(min_progress = 98)
}
\seealso{
Other progress functions: 
\code{\link{check_progress}()},
\code{\link{exclude_progress}()}

Other mark functions: 
\code{\link{mark_duplicates}()},
\code{\link{mark_duration}()},
\code{\link{mark_ip}()},
\code{\link{mark_location}()},
\code{\link{mark_preview}()},
\code{\link{mark_resolution}()}
}
\concept{mark functions}
\concept{progress functions}
