% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps.R
\name{kgaps}
\alias{kgaps}
\title{Maximum likelihood estimation for the \eqn{K}-gaps model}
\usage{
kgaps(data, u, k = 1, inc_cens = FALSE)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{u}{A numeric scalar.  Extreme value threshold applied to data.}

\item{k}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = \max(T - K, 0)}{S = max(T - K, 0)}.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times relating to the
first and last observation.  See Attalides (2015) for details.}
}
\value{
An object (a list) of class \code{c("kgaps", "exdex")} containing
    \item{\code{theta} }{The maximum likelihood estimate (MLE) of
      \eqn{\theta}.}
    \item{\code{se} }{The estimated standard error of the MLE.}
    \item{\code{ss} }{The list of summary statistics returned from
      \code{\link{kgaps_stat}}.}
    \item{\code{k, u, inc_cens} }{The input values of \code{k},
      \code{u} and \code{inc_cens}.}
    \item{\code{call }}{The call to \code{kgaps}.}
}
\description{
Calculates maximum likelihood estimates of the extremal index \eqn{\theta}
based on the \eqn{K}-gaps model for threshold inter-exceedances times of
Suveges and Davison (2010).
}
\details{
The maximum likelihood estimate of the extremal index \eqn{\theta}
  under the \eqn{K}-gaps model of Suveges and Davison (2010) is calculated.
  If \code{inc_cens = TRUE} then information from censored inter-exceedance
  times is included in the likelihood to be maximized, following
  Attalides (2015).  The form of the log-likelihood is given in the
  \strong{Details} section of \code{\link{kgaps_stat}}.

  It is possible that the estimate of \eqn{\theta} is equal to 1, and also
  possible that it is equal to 0. \code{\link{kgaps_stat}} explains the
  respective properties of the data that cause these events to occur.
}
\examples{
### S&P 500 index
u <- quantile(sp500, probs = 0.60)
theta <- kgaps(sp500, u)
theta
summary(theta)

### Newlyn sea surges

u <- quantile(newlyn, probs = 0.60)
theta <- kgaps(newlyn, u, k= 2)
theta
summary(theta)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{http://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{confint.kgaps}} to estimate confidence intervals
  for \eqn{\theta}.

\code{\link{kgaps_imt}} for the information matrix test, which
  may be used to inform the choice of the pair (\code{u, k}).

\code{\link{choose_uk}} for a diagnostic plot based on
  \code{\link{kgaps_imt}}.

\code{\link{kgaps_stat}} for the calculation of sufficient
  statistics for the \eqn{K}-gaps model.

\code{\link[revdbayes]{kgaps_post}} in the
  \code{\link[revdbayes]{revdbayes}} package for Bayesian inference
  about \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{spm}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.

\code{\link{iwls}}: iterated weighted least squares estimator.
}
