% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_uD.R
\name{choose_ud}
\alias{choose_ud}
\title{Threshold \eqn{u} and runs parameter \eqn{D} diagnostic for the \eqn{D}-gaps
estimator}
\usage{
choose_ud(data, u, D = 1, inc_cens = TRUE)
}
\arguments{
\item{data}{A numeric vector or numeric matrix of raw data.  If \code{data}
  is a matrix then the log-likelihood is constructed as the sum of
  (independent) contributions from different columns. A common situation is
  where each column relates to a different year.

  If \code{data} contains missing values then \code{\link{split_by_NAs}} is
  used to divide the data into sequences of non-missing values.}

\item{u, D}{Numeric vectors.  \code{u} is a vector of
  extreme value thresholds applied to data.  \code{D} is a vector of values
  of the run parameter \eqn{D}, as defined in Holesovsky and Fusek (2020).
  See \code{\link{dgaps}} for more details.

  Any values in \code{u} that are greater than all the observations in
  \code{data} will be removed without a warning being given.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from right-censored inter-exceedance times, relating to the
first and last observations. It is known that these times are greater
than or equal to the time observed.
If \code{data} has multiple columns then there will be right-censored
first and last inter-exceedance times for each column.  See
\strong{Details} in \code{\link{dgaps}}.}
}
\value{
An object (a list) of class \code{c("choose_ud", "exdex")}
  containing
  \item{imt }{an object of class \code{c("dgaps_imt", "exdex")} returned
    from \code{\link{dgaps_imt}}.}
  \item{theta }{a \code{length(u)} by \code{length(D)} matrix.
    Element (i,j) of \code{theta} contains an object (a list) of class
    \code{c("dgaps", "exdex")}, a result of a call
    \code{dgaps(data, u[j], D[i])} to \code{\link{dgaps}}.}
}
\description{
Creates data for a plot to aid the choice of the threshold and
run parameter \eqn{D} for the \eqn{D}-gaps estimator (see
\code{\link{dgaps}}).  \code{\link{plot.choose_ud}} creates the plot.
}
\details{
For each combination of threshold in \code{u} and \eqn{D}
  in \code{D} the functions \code{\link{dgaps}} and \code{\link{dgaps_imt}}
  are called in order to estimate \eqn{\theta} and to perform the
  information matrix test of Holesovsky and Fusek (2020).
}
\examples{
### S&P 500 index

# Multiple thresholds and left-censoring parameters
u <- quantile(sp500, probs = seq(0.2, 0.9, by = 0.1))
imt_theta <- choose_ud(sp500, u = u, D = 1:5)
plot(imt_theta)
plot(imt_theta, uprob = TRUE)
plot(imt_theta, y = "theta")

# One left-censoring parameter D, many thresholds u
u <- quantile(sp500, probs = seq(0.2, 0.9, by = 0.1))
imt_theta <- choose_ud(sp500, u = u, D = 1)
plot(imt_theta)
plot(imt_theta, y = "theta")

# One threshold u, many left-censoring parameters D
u <- quantile(sp500, probs = 0.9)
imt_theta <- choose_ud(sp500, u = u, D = 1:5)
plot(imt_theta)
plot(imt_theta, y = "theta")

### Newlyn sea surges

u <- quantile(newlyn, probs = seq(0.1, 0.9, by = 0.1))
imt_theta <- choose_ud(newlyn, u = u, D = 1:5)
plot(imt_theta, uprob = TRUE)

### Cheeseboro wind gusts (a matrix containing some NAs)

probs <- c(seq(0.5, 0.95, by = 0.05), 0.99)
u <- quantile(cheeseboro, probs = probs, na.rm = TRUE)
imt_theta <- choose_ud(cheeseboro, u, D = 1:6)
plot(imt_theta, uprob = FALSE, lwd = 2)

### Uccle July temperatures

probs <- c(seq(0.7, 0.95, by = 0.05), 0.99)
u <- quantile(uccle720m, probs = probs, na.rm = TRUE)
imt_theta <- choose_ud(uccle720m, u, D = 1:5)
plot(imt_theta, uprob = TRUE, lwd = 2)
}
\references{
Holesovsky, J. and Fusek, M. Estimation of the extremal index
  using censored distributions. Extremes 23, 197-213 (2020).
  \doi{10.1007/s10687-020-00374-3}
}
\seealso{
\code{\link{dgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{D}-gaps model.

\code{\link{dgaps_imt}} for the information matrix test under the
  \eqn{D}-gaps model

\code{\link{plot.choose_ud}} to produce the diagnostic plot.
}
