% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.R
\name{sum_row}
\alias{all_in_col}
\alias{all_in_row}
\alias{any_in_col}
\alias{any_in_row}
\alias{apply_col}
\alias{apply_row}
\alias{max_col}
\alias{max_row}
\alias{mean_col}
\alias{mean_row}
\alias{median_col}
\alias{median_row}
\alias{min_col}
\alias{min_row}
\alias{sd_col}
\alias{sd_row}
\alias{sum_col}
\alias{sum_row}
\title{Compute sum/mean/sd/median/max/min/custom function on rows/columns}
\usage{
sum_row(...)

sum_col(...)

mean_row(...)

mean_col(...)

sd_row(...)

sd_col(...)

median_row(...)

median_col(...)

max_row(...)

max_col(...)

min_row(...)

min_col(...)

apply_row(fun, ...)

apply_col(fun, ...)

any_in_row(...)

any_in_col(...)

all_in_row(...)

all_in_col(...)
}
\arguments{
\item{...}{data. Vectors, matrixes, data.frames, list. Shorter arguments
will be recycled.}

\item{fun}{custom function that will be applied to \dots}
}
\value{
All functions except \code{apply_*} return numeric vector of length 
  equals the number of argument columns/rows. Value of \code{apply_*} depends
  on supplied \code{fun} function.
}
\description{
This are convenience functions for usage inside \link{modify},
\link{modify_if}, \link[base]{with}, \link[base]{within} and \code{dplyr}
\code{mutate} functions. sum/mean/sd/median/max/min always omits NA.
\code{any_in_*} checks existence of any TRUE in each row/column. It is 
equivalent of \link[base]{any} applied to each row/column. \code{all_in_*} is
equivalent of \link[base]{all} applied to each row/column. They don't
remove NA.
}
\examples{
## Inside example
iris = modify(iris,{
  new_median = median_row(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
  new_mean = mean_row(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
  })
  
dfs = data.frame(
    test = 1:5,
    aa = rep(10, 5),
    b_ = rep(20, 5),
    b_1 = rep(11, 5),
    b_2 = rep(12, 5),
    b_4 = rep(14, 5),
    b_5 = rep(15, 5) 
)

# calculate sum of b* variables
modify(dfs, {
    b_total = sum_row(b_, b_1 \%to\% b_5)
})

# conditional modification
modify_if(dfs, test \%in\% 2:4, {
    b_total = sum_row(b_, b_1 \%to\% b_5)
})

# Examples from rowSums/colSums manual.
## Compute row and column sums for a matrix:
x = cbind(x1 = 3, x2 = c(4:1, 2:5))
sum_row(x); sum_col(x)
dimnames(x)[[1]] <- letters[1:8]
sum_row(x); sum_col(x); mean_row(x); mean_col(x)

}
\seealso{
\link{modify}, \link{modify_if}, \link{\%to\%}, \link{count_if},
  \link{sum_if}, \link{mean_if}, \link{median_if}, \link{sd_if},
  \link{min_if}, \link{max_if}
}

