% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchMark.R
\name{batchUnmarkViterbi}
\alias{batchUnmarkViterbi}
\title{batchUnmarkViterbi function provides the implementation of the Viterbi alogrithm for the unmarked model}
\usage{
batchUnmarkViterbi(phi, p, lambda, gam, Umax, nBins, u)
}
\arguments{
\item{phi}{The probability of surviving and remaining in the population between occasions t and t +1, given an individual was alive and in the population at occasion t. This must be a number between 0 and 1.}

\item{p}{The probability of capture at occasion t. This must be a number between 0 and 1.}

\item{lambda}{the initial mean abundance (at occasion 1) for the unmarked population.}

\item{gam}{The recruitment rate into the unmarked population}

\item{Umax}{The maximum number of the unmarked individuals in the population for capture on any occasion.}

\item{nBins}{The number of bin size into which the matrix will be divided.}

\item{u}{The number of individuals captured at sampling occasion t that were not marked; t = 1,...,T.}
}
\value{
Negative Log-likelihood value of the likelihood function
}
\description{
batchUnmarkViterbi function provides the implementation of the Viterbi alogrithm for the unmarked model
}
