% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz-distribution.R
\name{Gompertz}
\alias{Gompertz}
\alias{dgompertz}
\alias{pgompertz}
\alias{qgompertz}
\alias{rgompertz}
\title{Gompertz distribution}
\usage{
dgompertz(x, a = 1, b = 1, log = FALSE)

pgompertz(q, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

qgompertz(p, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

rgompertz(n, a = 1, b = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a, b}{positive valued scale and location parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Gompertz distribution.
}
\details{
Probability density function
\deqn{
f(x) = a \exp\left(bx - \frac{a}{b} (\exp(bx)-1)\right)
}{
f(x) = a*exp(b*x - a/b * (exp(b*x)-1))
}

Cumulative distribution function
\deqn{
F(x) = 1-\exp\left(-\frac{a}{b} (exp(bx)-1)\right)
}{
F(x) = 1-exp(-a/b * (exp(b*x)-1))
}

Quantile function
\deqn{
F^{-1}(p) = \frac{1}{b} \log\left(1-\frac{b}{a}\log(1-p)\right)
}{
F^-1(p) = 1/b * log(1 - b/a * log(1-p))
}
}
\examples{

x <- rgompertz(1e5, 5, 2)
xx <- seq(0, 1000, by = 0.1)
hist(x, 100, freq = FALSE)
lines(xx, dgompertz(xx, 5, 2), col = "red")
hist(pgompertz(x, 5, 2))
plot(ecdf(x))
lines(xx, pgompertz(xx, 5, 2), col = "red", lwd = 2)

}
\references{
Lenart, A. (2012). The Gompertz distribution and Maximum Likelihood Estimation
of its parameters - a revision. MPIDR WORKING PAPER WP 2012-008.
\url{http://www.demogr.mpg.de/papers/working/wp-2012-008.pdf}
}
\keyword{distribution}

