% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate-normal-distribution.R
\name{BivNormal}
\alias{BivNormal}
\alias{dbvnorm}
\alias{rbvnorm}
\title{Bivariate normal distribution}
\usage{
dbvnorm(x, y = NULL, mean1 = 0, mean2 = mean1, sd1 = 1, sd2 = sd1,
  cor = 0, log = FALSE)

rbvnorm(n, mean1 = 0, mean2 = mean1, sd1 = 1, sd2 = sd1, cor = 0)
}
\arguments{
\item{x, y}{vectors of quantiles; alternativelly x may be a two-column
matrix (or data.frame) and y may be omitted.}

\item{mean1, mean2}{vectors of means.}

\item{sd1, sd2}{vectors of standard deviations.}

\item{cor}{vector of correlations (\code{-1 < cor < 1}).}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function and random generation
for the bivariate normal distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{1}{2\pi\sqrt{1-\rho^2}\sigma_1\sigma_2}
       \exp\left(-\frac{1}{2(1-\rho^2)} (z_1^2 - 2\rho z_1 z_2 + z_2^2)\right)
}{
f(x) = 1/(2*\pi*sqrt(1-\rho^2)*\sigma1*\sigma2) * exp(-(1/(2*(1-\rho^2)*(z1^2 - 2*\rho*z1*z2 * z2^2))))
}

where \eqn{
z_1 = \frac{x_1 - \mu_1}{\sigma_1}
}{
z1 = (x1 - \mu1)/\sigma1
} and \eqn{
z_2 = \frac{x_2 - \mu_2}{\sigma_2}
}{
z2 = (x2 - \mu2)/\sigma2
}.
}
\examples{

y <- x <- seq(-4, 4, by = 0.25)
z <- outer(x, y, function(x, y) dbvnorm(x, y, cor = -0.75))
persp(x, y, z)

y <- x <- seq(-4, 4, by = 0.25)
z <- outer(x, y, function(x, y) dbvnorm(x, y, cor = -0.25))
persp(x, y, z)

}
\references{
Krishnamoorthy, K. (2006). Handbook of Statistical Distributions
with Applications. Chapman & Hall/CRC

Mukhopadhyay, N. (2000). Probability and statistical inference.
Chapman & Hall/CRC
}
\seealso{
\code{\link[stats]{Normal}}
}
\keyword{distribution}
