% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mean_sd_matrices.R
\name{calculate_mean_matrix}
\alias{calculate_mean_matrix}
\title{Create input for simulation based two-way factorial experiments}
\usage{
calculate_mean_matrix(
  refmean,
  nlfA,
  nlfB,
  fAeffect,
  fBeffect,
  groupswinteraction = NULL,
  interact = 1,
  label_list = NULL,
  sdproportional = TRUE,
  sdratio = 0.2,
  endincrement = FALSE,
  rho = 0,
  withinf = NULL,
  plot = TRUE
)
}
\arguments{
\item{refmean}{Numeric - expected mean for first level of both factors A and B}

\item{nlfA}{Integer - number of levels of factor A}

\item{nlfB}{integer - number of levels of factor B}

\item{fAeffect}{Numeric - multiple by which the refmean is modified when going from one level to the next of factor A when endincrement is FALSE (default), or multiple by which the last level of factor A is modified with respect to refmean when endincrement is TRUE}

\item{fBeffect}{Numeric - multiple by which the refmean is modified when going from one level to the next of factor B when endincrement is FALSE (default), or multiple by which the last level of factor B is modified with respect to refmean when endincrement is TRUE}

\item{groupswinteraction}{vector length 2 or n*2 matrix - Combination of levels from factors A and B in which interaction is expected}

\item{interact}{Numeric - value by which the mean from cell or cells indicated in groupswinteraction is multiplied after it has been calculated accordingly to fAeffect and fBeffect}

\item{label_list}{List length 2 - vectors with the names of the factor levels. The objects in this list should be named as the factors. The use of this option is encouraged as these names are inherited to ANOVA_design.}

\item{sdproportional}{Logical - whether the standard deviation for each combination of factor levels is a proportion of the respective factor level combination mean, defaults to TRUE}

\item{sdratio}{Numeric - value by which the expected mean value of a factor level combination is multiplied to obtain the respective standard deviation, defaults to 0.2.}

\item{endincrement}{Logical - determines if the multiples provided in fAeffect and fBeffect refer to change between first and last levels (default) or level to level changes.}

\item{rho}{Vector length 1 or 2, or 2 by 2 matrix - Controls how the correlation and hence de covariance matrix is built. See details.}

\item{withinf}{Character - Names the factor with repeated measures. Possible values are NULL, "fA", "fB" or "both"}

\item{plot}{Logical - Should a line plot with the modeled mean and standard deviations be part of the output. Default=TRUE}
}
\value{
If rho and whithinf are left at their default values of 0 and NULL, respectively, a list with two objects.

The first consist of two matrices, one of expected means for each cell of the two-way factorial experiment, one of expected standard deviations for said cells.

If rho is between -1 and 1 but different to 0 and whithinf is either "fA", "fB" or "both", along with the above mentioned output the output will include correlation and covariance matrices.
}
\description{
The calculate_mean_matrix will generate a matrix of expected mean values for i\emph{j group combinations of a two-way
factorial design, as well as a standard deviation matrix for these i}j groups.
If the design has repeated measures it will additionally provide correlation and covariance matrices calculated
depending on which factors are 'within' factors in the design.
}
\details{
The user must provide a reference mean (usually mean in control or untreated group), the expected change for each factor
from one level to the next (or from the first to last level) and the number of levels in each factor.

Also, if the user specifies factor level combinations which are expected to present interaction and its
magnitude with respect to the reference mean, the expected change in the cell means will be incorporated to the
aforementioned matrices.

We were motivated by sample size calculation for two-way factorial designs with a,b,...,i levels of factor A and
a,b,...,j levels of factor B in which the mean outcome value for replicates of cell A=a and B=a are known.
Furthermore, there is an expected change in level mean for each of the factors. Finally, interaction can be explicitly
introduced to level combinations in which it is expected to occur.

If a repeated measures experiment is intended 'withinf' must be set to "fA", "fB" or "both", depending on which is the "within" factor. If 'rho' is a vector length 1, the within subject correlation
will be constant for the factor defined in 'withinf'. If 'rho' is a vector length 2 and 'withinf' is either "fA" or "fB" a correlation gradient will be created from the first to second value of
'rho'. If 'rho' is a vector length 2 and 'withinf="both"', the first element of 'rho' will be the correlation within factor A, while the second element will be the correlation within factor B. If
'rho' is a 2*2 matrix, only possible if 'withinf="both"', a correlation gradient will be created across rows of 'rho' for each of the factors.
}
\examples{
refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)
## Independent design
effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            fAeffect = treateff, fBeffect = timeeff,
                                            nlfA = treatgroups, nlfB = timepoints,
                                            label_list = factors_levels_names)
## Inspect plot to check if matrices correspond to design
effects_treat_time$meansplot
n <- 20
independent_experiment <- twoway_simulation_independent(group_size = n,
                                      matrices_obj = effects_treat_time)

head(independent_experiment, 10)

## Repeated measures design, suppose subjects from 4 independent treatment groups measured
## at 5 different timepoints.
## We use the same parameters as the independent design example, except we add within factor level
## correlation and we specify that factor B is the within factor.


refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
rho <- 0.8
withinf <- "fB"

factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

effects_treat_time <- calculate_mean_matrix(refmean = refmean, fAeffect = treateff,
                      fBeffect = timeeff, nlfA = treatgroups,  nlfB = timepoints,
                      rho = rho, withinf = withinf, label_list = factors_levels_names)

## Plot should look the same, structure within data can be checked once simulated
effects_treat_time$meansplot

n <- 20
repeatedmeasures_experiment <- twoway_simulation_correlated(group_size = n,
                                          matrices_obj = effects_treat_time)
head(repeatedmeasures_experiment, 10)

}
