% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{wecdf}
\alias{wecdf}
\title{Weighted Empirical Cumulative Distribution Function}
\usage{
wecdf(X, x, weights = rep(1, length(X)))
}
\arguments{
\item{X}{the vector of data to create the wecdf.}

\item{x}{the vector of data that you want the corresponding wecdf values.}

\item{weights}{the weights applicated to the vector \eqn{X}.}
}
\value{
Return a vector of the wecdf values corresponding to \eqn{x} given a reference vector \eqn{X} with weights \eqn{weights}.
}
\description{
Calculate the values of the weighted empirical cumulative distribution function for a given vector of data
}
\details{
Give the value of the wecdf.
If the weights are 1 (the default value), the wecdf become the ecdf of \eqn{X}.
}
\examples{

X <- rpareto(10)
x <- seq(0.8, 50, 0.01)
plot(x, wecdf(X, x, rep(1,length(X))))

#to compare with the ecdf function
f <- ecdf(X)
lines(x, f(x), col = "red", type = "s")

}
