% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extremogramr.R
\name{extremogramr}
\alias{extremogramr}
\title{Sample return time extremogram}
\usage{
extremogramr(x, type, maxlag, uplevel = 1, lowlevel = 0, histogram = 1,
  cutoff = 1, ...)
}
\arguments{
\item{x}{Univariate time series (a vector).}

\item{type}{Extremogram type. If type = 1, the upper tail extremogram is estimated. If type = 2,
the lower tail extremogram is estimated. If type = 3, both upper and lower tail
extremogram is estimated.}

\item{maxlag}{Number of lags to include in the extremogram (an integer).}

\item{uplevel}{Quantile of the time series to indicate a upper tail extreme event
(a number between 0 and 1, default is 1).}

\item{lowlevel}{Quantile of the time series to indicate a lower tail extreme event
(a number between 0 and 1, default is 0).}

\item{histogram}{An extremogram plot. If histogram = 1, a plot is created (default). If histogram = 0,
no plot is created.}

\item{cutoff}{The cutoff of the y-axis on the plot (a number between 0 and 1, default is 1).}

\item{...}{further arguments: plot and axis names.}
}
\value{
Extremogram values, return time for extreme events, mean return time and a plot (if requested).
}
\description{
The function estimates the sample return time extremogram and creates an extremogram plot.
}
\examples{
# generate a GARCH(1,1) process
omega    = 1
alpha    = 0.1
beta     = 0.6
n        = 1000
uplevel  = 0.95
lowlevel = 0.05
type     = 3
maxlag   = 70
df       = 3
G = extremogram:::garchsim(omega,alpha,beta,n,df)

extremogramr(G, type, maxlag, uplevel, lowlevel, 1, 1)
}
\references{
\enumerate{
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2012). Towards estimating extremal
            serial dependence via the bootstrapped extremogram. Journal of Econometrics,170(1),
            142-152.
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2011). Estimating extremal
            dependence in univariate and multivariate time series via the extremogram.arXiv
            preprint arXiv:1107.5592.}
}

