% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_wio.R
\name{make_wio}
\alias{make_wio}
\title{Make standard world input-output matrices from source files}
\usage{
make_wio(wiotype = "icio2023", year = NULL, src_dir = NULL, quiet = FALSE)
}
\arguments{
\item{wiotype}{String specifying the name and edition of the
input-output tables to be used:
* \code{"icio2023"} for the 2023 edition of the OECD ICIO tables
(1995-2020) and \code{"icio2023s"} for the small format of the same edition.
The deprecated editions \code{"icio2021"} (1995-2018),
\code{"icio2018"} (1995-2011) and \code{"icio2016"}(2005-2015) remain
available for literature replication purposes.
* \code{"wiod2016"} for the 2016 edition of the WIOD tables
(2000-2014). The deprecated edition \code{"wiod2013"} (1995-2011)
remains available for literature replication purposes.
* \code{"lrwiod2022"} for the 2022 edition of the long-run WIOD
(1965-2000), useful for historical analysis.
* \verb{"figaro2023i} for the 2023 edition of the FIGARO EU Input-Output
Tables (EU IC-SUIOTs), industry-by-industry (2010-2021), and
\verb{"figaro2023p} for the product-by-product version of the same
database.The deprecated edition of 2022 (2010-2020)
remains available for literature replication purposes.
* \code{"iciotest"} for an example of an ICIO-type international
input-output table (disaggregated for \code{MEX} into \code{MX1} and \code{MX2} and
for \code{CHN} into \code{CN1} and \code{CN2}) and \code{"wiodtest"} for an example of a
WIOD-type international input-output table (not disaggregated). Data
for these tables is not real, but these small input-output tables
are useful for didactic purposes and to check the functionality of
the program.}

\item{year}{Integer specifying reference year. If \code{NULL} (default),
the last available year of the specified database will be used.}

\item{src_dir}{String specifying the source directory where the source file
of the international input-output tables is saved, normally as a zip file
(containing \code{.csv} files, \code{.RData} or \code{.xlsx} files, see Details). In
order for \code{make_wio()} to work, these zip files should not be renamed.
If \code{src_dir} is not specified, \code{make_wio()} will look in the
working directory.}

\item{quiet}{Boolean, if \code{TRUE} suppress all status messages. Default
is \code{FALSE}, i.e., messages are shown.}
}
\value{
A list object of class \code{wio} including input-output
matrices, dimensions, and names.
}
\description{
Creates a list object of class \code{wio} containing the typical
international input-output matrices in a standardized format, as well as a
list of code names (countries, sectors and demand components) and a list
of dimensions (number of countries, sectors and demand components). It
can use source files from well-known databases or internal data (test
data).
}
\details{
\code{make_wio()} directly unzips and processes the original source files
for the different international input-output tables and returns a list
with the traditional matrices, including the coefficient matrix \code{A}, the
Leontief global inverse matrix \code{B}, the Leontief matrix of local inverse
matrices \code{Ld} and others.

Original source files can be obtained in the OECD's
\href{https://www.google.com/search?q=OECD+ICIO+tables}{ICIO web page}
or in the University of Groningen's
\href{https://www.rug.nl/ggdc/valuechain/wiod/}{WIOD web page} or in the
\href{https://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/database}{Eurostat web page}

If source files are used, they must be previously downloaded and
placed in an accessible folder in disk, without renaming them. The
following name pattern is expected:
\itemize{
\item \code{XXXX-XXXX.zip} for \code{"icio2023"} (\code{.csv} files)
\item \code{XXXX-XXXX_SML.zip} for \code{"icio2023s"} (\code{.csv} files)
\item \code{ICIO_XXXX-XXXX.zip} for \code{"icio2021"} (\code{.csv} files)
\item \code{ICIO2018_XXXX.zip} for \code{"icio2018"} (\code{.csv} files)
\item \code{ICIO2016_XXXX.zip} for \code{"icio2016"} (\code{.csv} files)
\item \code{WIOTS_in_R.zip} for \code{"wiod2016"} (\code{.RData} files)
\item \code{WIOTS_in_EXCEL.zip} for \code{"wiod2013"} (\code{.xlsx} files). Requires
package \code{openxlsx}..
\item \code{lr_wiod_wiot_final_filled.csv} for \code{"lrwiod2022"}. Requires
packages \code{data.table} and \code{reshape2}.
\item \code{matrix_eu-ic-io_ind-by-ind_23ed_XXXX.csv} for \verb{"figaro2023i} and
\code{matrix_eu-ic-io_prod-by-prod_23ed_XXXX.csv} for \verb{"figaro2023p}
(\code{.csv} files)
The input-output framework follows the traditional demand model of
Leontief (1936), which makes assumptions about the stability of inputs
(and therefore value-added) as a proportion of production. This allows
production and value-added to be expressed as the result of variations
in final demand.\
Details about the content of the world input-output object (\code{wio})
produced by \code{make_wio()} can be obtained with the command
\code{summary(wio_object)}.
}
}
\examples{
wio <- make_wio("iciotest")
summary(wio)
\dontrun{
# The following examples require the previous download of the source
# files in the working directory or in a directory specified by `src_dir`.
wio <- make_wio("icio2023", 2020)
wio <- make_wio("wiod2021", 2018)
wio <- make_wio("wiod2023", 2020, src_dir = "C:/Users/John/R/")
}
}
\seealso{
\code{\link[=make_custom_wio]{make_custom_wio()}}
}
