% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get data from different exvatools objects}
\usage{
get_data(
  exvatools_object,
  var,
  exporter,
  sector = "TOTAL",
  importer = "WLD",
  demand_comp = "TOTAL",
  custom = FALSE
)
}
\arguments{
\item{exvatools_object}{An \code{exvatools} object (\code{wio},
\code{exvadec} or \code{exvadir}). If it is an ICIO \code{wio}, it will
be previously melded (i.e., China and Mexico will be grouped).}

\item{var}{String for the selected variable included in the \code{exvatools}
object: \code{"VA"}, \code{"X"}, \code{"EXGR"}, \code{"VAX"},
\code{"DC"}, \code{"DVA"}, etc.}

\item{exporter}{String vector with codes of the exporting countries.\
If the \code{exvadec} object includes only one country or country group,
\code{exporter} is not required (data can only be extracted
for that country).\
If \code{exporter} is not specified and it is an \code{exvadir} object,
the exporter will be considered the world (\code{"WLD"}), as by
definition exporters in \code{exvadir} objects are the countries of
origin of value added. \
To include a vector with several exporters (e.g., \code{c("ESP", "FRA")})
the \code{exvadec} object must have been created with the option
\code{exporter = "all"} in the command \code{\link[=make_exvadec]{make_exvadec()}}.
\code{get_data()} will then produce matrices horizontally bound.}

\item{sector}{A character vector with sector codes, e.g. \code{TOTAL},
\code{AGF}, \code{MANUF}, \code{c("TOTAL", "AGF", "MANUF", "SERVS")}.
Available codes can be checked with \code{\link[=info_sec]{info_sec()}}.}

\item{importer}{String vector with importing country or country group codes,
e.g. \code{"WLD"}, \code{"ESP"}, \code{"EU27"}, \code{c("WLD", "EU27", "NONEU27")}. Available codes can be checked with
\code{\link[=info_geo]{info_geo()}}.\
Please note that country groups will not show the strict values of
\code{"DVA"}, \code{"VAX"} etc. but an average value of the countries
included in that group. To obtain the specific \code{"DVA"},
\code{"VAX"}, etc. for a group, an \code{exvadec} object must be
specifically created for that country group.\
Of course, variables that do not require to exclude double-counting,
like \code{"EXGR"}, \code{"DC"} or\code{"FC"} will be the same in
both cases, so no specific \code{exvadec} object will be required.}

\item{demand_comp}{A character vector of demand components, e.g.,
\code{"HFCE"}, \code{c("HFCE", "GCFC")}. Only valid for \code{wio}
objects.}

\item{custom}{Boolean specifying whether custom-made groups of countries
or sectors are present in the environment to be used. For instance, a
custom \code{HITECH} custom variable including high-tech sectors or
a \code{LDC} variable with list of least-developed countries. Note that
custom variables should be referred to as strings in \code{get_data()},
i.e. as \code{"HITECH"} and \code{"LDC"}.}
}
\value{
A two-dimensional matrix with sector and geographical data of a
variable.
}
\description{
Extracts exporting country and sector and destination data from a specific
variable in an \code{exvatools} object.
}
\examples{
wio <- make_wio("wiodtest")
get_data(wio, "EXGR", exp = "ESP", sec = "MANUF")
get_data(wio, "EXGR", exp = "ESP", sec = c("TOTAL", "MANUF", "SRVWC"),
         imp = c("USA", "FRA"))
}
