% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_saccades.R
\name{extract_saccades}
\alias{extract_saccades}
\alias{extract_saccades.data.frame}
\alias{extract_saccades.eyelinkRecording}
\title{Extract saccades from recorded events}
\usage{
extract_saccades(object)

\method{extract_saccades}{data.frame}(object)

\method{extract_saccades}{eyelinkRecording}(object)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{saccades} slot or a data.frame with saccades' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extract saccades from the \code{events} table of the \code{\link{eyelinkRecording}} object.
Normally, you don't need to call this function yourself,
as it is called during the \code{\link{read_edf}} with default
settings (\emph{e.g.}, \code{import_saccades = TRUE}).
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_saccades(gaze)

# by passing events table
saccades <- extract_saccades(gaze$events)
}
\seealso{
read_edf, eyelinkRecording
}
