% Generated by roxygen2 (4.0.1): do not edit by hand
\name{createFormula}
\alias{createFormula}
\title{Create Formula From a Vector of Character.}
\usage{
createFormula(x, right = TRUE)
}
\arguments{
\item{x}{A vector of character}

\item{right}{If there is only one element in \code{x}, should it appear in the left or right hand side of the formula.}
}
\value{
Formula
}
\description{
Elements of the vector is evenly distributed to both of the formula. Each element in the formula is seperated by \code{+}.
}
\note{
For internal use of ezsim. It aims at creating formula for facets in \pkg{ggplot2}.
}
\examples{
\dontrun{
createFormula(letters[1])  ## . ~ a
createFormula(letters[1],right=FALSE)  ## a ~ .
createFormula(letters[1:3])  ## c ~ a + b
createFormula(letters[1:4])  ## c + d ~ a + b
createFormula(letters[1:4],right=FALSE) ## a + b ~ c + d
}
}
\author{
TszKin Julian Chan \email{ctszkin@gmail.com}
}
\seealso{
\code{\link{formula}}
}
\keyword{internal}

