% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_sprint.R
\name{load_sprint}
\alias{load_sprint}
\title{Load Sprint Results}
\usage{
load_sprint(season = get_current_season(), round = "last")
}
\arguments{
\item{season}{number from 2021 to current season  (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season), and defaults
to most recent. Also accepts \code{'last'}.}
}
\value{
A dataframetibble with columns driver_id, constructor_id, points awarded, finishing position,
grid position, laps completed, race status (finished or otherwise), gap to
first place, fastest lap, fastest lap time, fastest lap in seconds,
or NULL if no sprint exists for this season/round combo
}
\description{
Loads final race results for a given year and round. Note not all rounds have
sprint results. Use \code{.load_sprint()} for an uncached version of this function.
}
