
print.dma <- function(x, ...)
  {
   cat("Model: ")
   cat(colnames(x$y))
   cat(" ~ ")
   cat(colnames(x$models))
   cat("\n")
   cat("\n")
   print(x$parameters)
   cat("\n")
   err <- rbind(x$MSE,x$MAE)
   colnames(err) <- c("model")
   err <- cbind(err,x$benchmarks)
   print(round(err,digits=4))
   cat("\n")
   cat("observations: ")
   cat(length(x$y.hat))
   cat("\n")
   cat("models: ")
   cat(nrow(x$models))
   cat("\n")
   cat("variables (incl. constant): ")
   cat(ncol(x$models))
  }
