% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_parameters.R
\name{fHMM_parameters}
\alias{fHMM_parameters}
\title{Setting and checking model parameters}
\usage{
fHMM_parameters(
  controls,
  Gamma = NULL,
  mus = NULL,
  sigmas = NULL,
  dfs = NULL,
  Gammas_star = NULL,
  mus_star = NULL,
  sigmas_star = NULL,
  dfs_star = NULL,
  seed = NULL,
  scale_par = c(1, 1)
)
}
\arguments{
\item{controls}{An object of class \code{fHMM_controls}.}

\item{Gamma}{A tpm (transition probability matrix) of dimension \code{controls$states[1]}.}

\item{mus}{A vector of expectations of length \code{controls$states[1]}.}

\item{sigmas}{A vector of standard deviations of length \code{controls$states[1]}.}

\item{dfs}{A vector of degrees of freedom of length \code{controls$states[1]}.
Only relevant if sdd is a t-distribution.}

\item{Gammas_star}{A list of length \code{controls$states[1]} of (fine-scale) tpm's. Each tpm
must be of dimension \code{controls$states[2]}.}

\item{mus_star}{A list of length \code{controls$states[1]} of vectors of (fine-scale)
expectations. Each vector must be of length \code{controls$states[2]}.}

\item{sigmas_star}{A list of length \code{controls$states[1]} of vectors of standard deviations.
Each vector must be of length \code{controls$states[2]}.}

\item{dfs_star}{A list of length \code{controls$states[1]} of vectors of (fine-scale) degrees
of freedom. Each vector must be of length \code{controls$states[2]}.
Only relevant if sdd is a t-distribution.}

\item{seed}{Set a seed for the sampling of parameters.}

\item{scale_par}{A positive numeric vector of length two, containing scales for sampled
expectations and standard deviations. The first entry is the scale for
\code{mus} and \code{sigmas}, the second entry is the scale for
\code{mus_star} and \code{sigmas_star}. Set an entry to \code{1} for no
scaling.}
}
\value{
An object of class \code{fHMM_parameters}.
}
\description{
This function sets and checks model parameters for the {fHMM} package.
}
\details{
See the vignette on the model definition for more details.
}
\examples{
controls <- set_controls()
fHMM_parameters(controls)

}
