% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-check_table_values.R
\name{get_duplicated_rows}
\alias{get_duplicated_rows}
\title{Extract observations(rows) that have same values in a tibble}
\usage{
get_duplicated_rows(tbl, id_col = NULL)
}
\arguments{
\item{tbl}{R object(dataframe or tibble) of the input tibble}

\item{id_col}{A character string specifying the column to ignore in
identification of repeated observations. If NULL (by default), all of the
columns will be taken in account for repeated observation identification.
The row number will be used to identify those observations.}
}
\value{
A tibble indicating which row which values is the same in the tibble
}
\description{
This helper function extracts the row number (or first column value) in a
tibble having identical values for all columns. This function can be used
either on the whole columns or excluding the first column (id) (which can be
useful to identify repeated observation across different ids)
}
\examples{
{

# the row numbers are returned to identify which observations have repeated
# values
library(dplyr)
get_duplicated_rows(bind_rows(mtcars,mtcars[1,]))

get_duplicated_rows(
  tbl = bind_rows(mtcars,mtcars[1,]) \%>\%
        add_index() \%>\%
        mutate(index = paste0('obs_',index)),
  id_col = 'index')

}

}
