% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.video.formats.R
\name{facebook.video.formats}
\alias{facebook.video.formats}
\title{Pull the list of video formats available from a set of photos}
\usage{
facebook.video.formats(id, token = NULL, parameters = list(),
  fields = c("embed_html", "picture", "filter", "height", "width"),
  .progress = create_progress_bar())
}
\arguments{
\item{id}{An existing \code{\link{FacebookPhotosCollection}}.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If it's \code{NULL}, the token from \code{id} is used.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A named list with all the formats of the given photos. The name of is set to the \code{id} of the photo.
}
\description{
\code{facebook.video.formats} pulls information about the formats of a set of photos 
in a \code{link{FacebookPhotosCollection-class}} and push into a named list.
}
\section{Valid sources}{

\itemize{
 \item{\code{\link{FacebookVideosCollection-class}} will build a collection with 
 the formats available for the videos in the source collection.}
}
}

\seealso{
\code{\link{FacebookAlbumsCollection}}, \code{\link{FacebookPhotosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
