\name{CDA}
\alias{CDA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
function performing a Canonical Discriminant Analysis on a given data table or on (simulated) data streams.
}
\description{
This function permits user to perform fast Canonical Discriminant Analysis on (high dimensional on-line) data.  

Using stochastic processes, several estimation may be calculated depending on the user goals:
principal canonical factors, principal canonical axes, eigenvalues and correlation coefficients between the original
variables and the principal canonical factors can be computed and updated recursively.
 
Moreover, graphics may be printed in order to give a better visualization and meaning/interpretation of
the data. It's possible to get meaningful 2D visualizations: the observations are projected on the plans generated
 by direction vectors of the principal axes.  Correlation circles that show a
projection of the initial variables in the factors space are also available.
}
\usage{
CDA(data,groups,stream=TRUE,nb_fact,principal_factors=TRUE,principal_axes=FALSE,
eigenvalues=FALSE,corr=FALSE,graphics=FALSE,data_init,exec_time,print_step)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
matrix : data to be analysed. The columns will represent the variables and 
the rows will represent the observations (sometimes called records, subjects or cases).
If you consider on-line data (\code{stream=TRUE}), of course all the observations are not available at the
beginning of the analysis. Thus, each observation (line of the matrix) will be treated 
individually (and then forgotten) to simulate the data stream.     
}
  \item{groups}{vector ( of dimension 2 ) : the first component (>1) corresponds to the dimension/length of the group of quantitative variables, the
second component (>1) gives the number of categories for the nominative variable.
}
  \item{stream}{
boolean : stream=TRUE if you consider data streams; stream=FALSE otherwise.
}
  \item{nb_fact}{
integer : number of elements to be calculated. For instance, if you need
 the three first principal canonical factors, nb_fact=3.
}
  \item{principal_factors}{ boolean : principal_factors=TRUE if you need the value of some first
principal canonical factors; principal_factors=FALSE otherwise.
}
  \item{principal_axes}{ boolean : principal_axes=TRUE if you need the value of some first
principal canonical axes; principal_axes=FALSE otherwise.
}
  \item{eigenvalues}{boolean : eigenvalues=TRUE if you need the value of some first
eigenvalues; eigenvalues=FALSE otherwise.
}
  \item{corr}{boolean : corr=TRUE if you need the value of correlation coefficient between the
original variables and some first principal canonical factors; corr=FALSE otherwise.
}
  \item{graphics}{
boolean : if graphics=TRUE, 2D visualizations will be plotted, representing
projections of the observations on all the plans generated by the \code{nb_fact} direction vectors
of the principal axes. If corr=TRUE, correlation circles that show a projection of the initial variables in the factors
spaces will also be plotted; if graphics=FALSE, no graphics will be plotted.


N.B. : For the fist kind of graphics, a gradation of grey was chosen to represent the "age" of the observations. The darker a point is, the newer the observation is. This coding
is meaningful for a data stream (stream=TRUE). If stream=FALSE, the "age" concept is less relevant: in this configuration, the darker a point is, the lower the observation is in
the matrix (database).  
}
  \item{data_init}{
integer : this argument is only relevant when stream=TRUE. It represents the number
of data used to intialize the analysis. It must be at least equal to the  number of columns of the dataset.
}
  \item{exec_time}{
real : execution time. If stream=TRUE, the analysis will stop when one of
these two events happen: all the data have been taken into account or execution time achieved. Otherwise, it's the execution time of \code{\link{CDA_iter}}
}
  \item{print_step}{
integer: this argument is only relevant when stream=TRUE. Each time that a new observation
is taken into account, a new estimation of the principal canonical factors (or principal canonical axes, ...) is computed but not
necessarily printed : it will be printed only every \code{print_step} observations.  
}
}
\details{

Reminding that CDA is an analysis achieved on two groups of variables only (one quantitative and the other nominative or qualitative), we precise that the \code{CDA} function computes the canonical elements
(principal factors, principal axes, ...) associated with the first group of (quantitative) variables only.

To compute the function, the group of quantitative variables must be the first group in the dataset and the values taken by the nominative variables must be exclusive categories.
Indeed, a preprocessing is done on the nominative variables to obtain a codage composed of 1 and 0, essential to achieve the analysis.


}
\value{
results that user needs (principal factors, principal axes, eigenvalues and correlation coefficients)
}
\references{
ACP projetée de données séquentielles, Monnez J.-M. 42èmes Journées de Statistique (2010) 
}
\author{
BAR Romain, Univeristé de Lorraine, IECL, INRIA : BIGS group.
}
\seealso{ 
\code{\link{CDA_iter}}
}

\examples{

data(wolves)
CDA(rbind(wolves,wolves,wolves),c(9,4),stream=TRUE,3,principal_factors=TRUE,
principal_axes=TRUE,eigenvalues=TRUE,corr=TRUE,graphics=TRUE,25,2,100)

}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{canonical discriminant analysis}

