% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic-reference.R
\name{factorH_reference}
\alias{factorH_reference}
\alias{factorH-reference}
\alias{reference.factorH}
\title{factorH functions reference}
\description{
factorH functions reference
}
\details{
\subsection{Function reference}{

This document collects \strong{call patterns} and \strong{options} for each public
function. All formulas follow response ~ A + B (+ C …) with \strong{numeric}
response and \strong{factor} predictors.

\strong{srh.kway.full()}

\strong{Purpose:} one-call pipeline: ANOVA on ranks + descriptives + post
hocs + simple effects.
\strong{Syntax:} srh.kway.full(y ~ A + B (+ C …), data, max_levels = 30)
\itemize{
\item Automatically chooses the ANOVA engine:
\itemize{
\item 1 factor: srh.kway()
\item 2 factors: srh.effsize()
\item 3+ factors: srh.kway()
}
\item Returns a list: anova, summary, posthoc_cells, posthoc_simple, meta.
\item Placeholders:
\itemize{
\item \emph{not applicable} when a component does not apply (e.g., simple
effects with 1 factor),
\item \emph{failed…} when a sub-step errors out (keeps the pipeline alive).
}
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{res <- srh.kway.full(liking ~ gender + condition + age_cat, data = mimicry)
names(res)
res$anova[1:3]
head(res$summary)
names(res$posthoc_cells)
names(res$posthoc_simple)[1:3]
res$meta
}\if{html}{\out{</div>}}

\strong{Notes:}
\itemize{
\item Predictors are coerced to factor internally; levels must be
2..max_levels.
\item Missing values are removed \strong{pairwise} on the variables in the
formula.
}

\strong{write.srh.kway.full.tsv()}

\strong{Purpose:} export the srh.kway.full() result into a single TSV file
for fast formatting.
\strong{Syntax:} write.srh.kway.full.tsv(obj, file = “srh_kway_full.tsv”, sep
= “, na =”“, dec =”.”)
\itemize{
\item dec = “.” or “,” controls the decimal mark.
\item Numeric fields are written without scientific notation.
\item Pretty-printed character tables (e.g., from post hocs) are normalized
so that dec=“,” also affects numbers embedded in strings.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{f <- tempfile(fileext = ".tsv")
write.srh.kway.full.tsv(res, file = f, dec = ",")
file.exists(f)
}\if{html}{\out{</div>}}

\strong{srh.kway()}

\strong{Purpose:} general k-way SRH-style ANOVA on ranks (Type II SS),
tie-corrected p-values.
\strong{Syntax:} srh.kway(y ~ A + B (+ C …), data, clamp0 = TRUE,
force_factors = TRUE, …)
\itemize{
\item Reports: Effect, Df, Sum Sq, H, Hadj (tie correction), p.chisq, k, n,
eta2H, eps2H.
\item eta2H and eps2H are computed from \strong{unadjusted H} (classical SRH
practice).
\item force_factors = TRUE coerces predictors to factor (recommended).
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{k3 <- srh.kway(liking ~ gender + condition + age_cat, data = mimicry)
k3
}\if{html}{\out{</div>}}

One-factor check (KW-like):

\if{html}{\out{<div class="sourceCode">}}\preformatted{k1 <- srh.kway(liking ~ condition, data = mimicry)
k1
}\if{html}{\out{</div>}}

\strong{srh.effsize()}

\strong{Purpose:} 2-way SRH table with effect sizes from H.
\strong{Syntax:} srh.effsize(y ~ A + B, data, clamp0 = TRUE, …)
\itemize{
\item Same columns as above but tailored to 2-way SRH.
\item clamp0 = TRUE clamps small negatives to 0 for effect sizes.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{e2 <- srh.effsize(liking ~ gender + condition, data = mimicry)
e2
}\if{html}{\out{</div>}}

\strong{nonpar.datatable()}

\strong{Purpose:} compact descriptive tables (APA-style), with \strong{global rank
means}, medians, quartiles, IQR.
\strong{Syntax:} nonpar.datatable(y ~ A + B (+ C …), data, force_factors =
TRUE)
\itemize{
\item Returns rows for all \strong{main effects} and all \strong{interaction cells}
(constructed internally).
\item Rank means are computed on \strong{global ranks} (all observations ranked
together), which matches how rank-based ANOVA effects are formed.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{dt <- nonpar.datatable(liking ~ gender + condition, data = mimicry)
head(dt)
}\if{html}{\out{</div>}}

\strong{srh.posthoc()}

\strong{Purpose:} Dunn–Bonferroni \strong{pairwise comparison matrix} for a
specified effect.
\strong{Syntax:} srh.posthoc(y ~ A (+ B + …), data, method = “bonferroni”,
digits = 3, triangular = c(“lower”,“upper”,“full”), numeric = FALSE,
force_factors = TRUE, sep = “.”)
\itemize{
\item Builds a single grouping variable (cells) from the RHS factors and
runs FSA::dunnTest.
\item Returns a list of three matrices (as data.frames): Z, P.unadj, P.adj.
\item triangular = “lower” (default) shows only the lower triangle; diagonal
and upper triangle are blank.
\item numeric = FALSE returns pretty-printed character tables; set TRUE to
get numeric.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ph <- srh.posthoc(liking ~ condition, data = mimicry)
}\if{html}{\out{</div>}}

\strong{srh.posthocs()}

\strong{Purpose:} Dunn–Bonferroni \strong{pairwise matrices for all effects} (main
and interactions).
\strong{Syntax:} srh.posthocs(y ~ A + B (+ C …), data, …)
\itemize{
\item Iterates srh.posthoc over: A, B, C, A:B, A:C, B:C, A:B:C, …
\item Returns a named list: names are “A”, “B”, “A:B”, etc.; each value is a
P.adj matrix.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{phs <- srh.posthocs(liking ~ gender + condition + age_cat, data = mimicry)
names(phs)
phs[["gender:condition"]][1:5, 1:5]
}\if{html}{\out{</div>}}

\strong{srh.simple.posthoc()}

\strong{Purpose:} \strong{Simple-effects} post hocs (pairwise comparisons
\strong{within} levels of conditioning factors).
\strong{Syntax:} srh.simple.posthoc(y ~ A + B (+ C …), data, compare = NULL,
scope = c(“within”,“global”), digits = 3)
\itemize{
\item compare selects the target factor for pairwise comparisons (default:
first RHS factor).
\item \strong{Scope}:
\itemize{
\item “within” (default): Bonferroni \strong{within each by-table} (SPSS-like).
\item “global”: one Bonferroni across \strong{all} tests from all by-tables
combined.
}
\item Returns a data.frame with conditioning columns (BY), Comparison, Z,
P.unadj, P.adj, m.tests, adj.note. An “adjustment” attribute describes
the correction.
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{simp <- srh.simple.posthoc(liking ~ gender + condition + age_cat, data = mimicry, compare = "gender", scope = "within")
head(simp)
}\if{html}{\out{</div>}}

\strong{srh.simple.posthocs()}

\strong{Purpose:} enumerate \strong{all simple-effect configurations} for a given
design.
\strong{Syntax:} srh.simple.posthocs(y ~ A + B (+ C …), data)
\itemize{
\item For each target factor and each non-empty combination of the remaining
factors as BY, runs srh.simple.posthoc(…, scope = “within”).
\item Returns a named list, names like COMPARE(gender) | BY(condition x
age_cat).
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{sps <- srh.simple.posthocs(liking ~ gender + condition + age_cat, data = mimicry)
head(names(sps), 6)
}\if{html}{\out{</div>}}

\strong{Formula tips and pitfalls}
\itemize{
\item Do \strong{not} write A:B or A*B. Use A + B (+ C …); the package computes
all necessary interaction structures internally.
\item Response must be \strong{numeric}. For Likert data, keep it numeric 1..k.
\item Predictors should be \strong{factors}. If they are not, they will be
coerced.
\item Coerce predictors to factor explicitly if needed
}

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#coercing
mimicry$gender <- factor(mimicry$gender)
mimicry$condition <- factor(mimicry$condition)
}\if{html}{\out{</div>}}

\strong{Performance and reproducibility}
\itemize{
\item Functions use ranks and Type II sums of squares (via car::Anova under
the hood) and Dunn tests (FSA::dunnTest).
\item P-values apply a standard tie correction factor for ranks; effect
sizes are derived from unadjusted H (classical SRH practice).
\item All outputs are plain data.frames and lists, easy to save and
post-process.
}
}
}
