# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title SPARCalculationParameters
#' @description SPARCalculationParameters Class
#' @format An \code{R6Class} generator object
#' @field componentid  character 
#'
#' @field accounts  list( \link{SPARIdentifier} ) [optional]
#'
#' @field benchmark  \link{SPARIdentifier} [optional]
#'
#' @field dates  \link{SPARDateParameters} [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
SPARCalculationParameters <- R6::R6Class(
  'SPARCalculationParameters',
  public = list(
    `componentid` = NULL,
    `accounts` = NULL,
    `benchmark` = NULL,
    `dates` = NULL,
    initialize = function(`componentid`, `accounts`=NULL, `benchmark`=NULL, `dates`=NULL, ...){
      local.optional.var <- list(...)
      if (!missing(`componentid`)) {
        stopifnot(is.character(`componentid`), length(`componentid`) == 1)
        self$`componentid` <- `componentid`
      }
      if (!is.null(`accounts`)) {
        stopifnot(is.vector(`accounts`), length(`accounts`) != 0)
        sapply(`accounts`, function(x) stopifnot(R6::is.R6(x)))
        self$`accounts` <- `accounts`
      }
      if (!is.null(`benchmark`)) {
        stopifnot(R6::is.R6(`benchmark`))
        self$`benchmark` <- `benchmark`
      }
      if (!is.null(`dates`)) {
        stopifnot(R6::is.R6(`dates`))
        self$`dates` <- `dates`
      }
    },
    toJSON = function() {
      SPARCalculationParametersObject <- list()
      if (!is.null(self$`componentid`)) {
        SPARCalculationParametersObject[['componentid']] <-
          self$`componentid`
      }
      if (!is.null(self$`accounts`)) {
        SPARCalculationParametersObject[['accounts']] <-
          lapply(self$`accounts`, function(x) x$toJSON())
      }
      if (!is.null(self$`benchmark`)) {
        SPARCalculationParametersObject[['benchmark']] <-
          self$`benchmark`$toJSON()
      }
      if (!is.null(self$`dates`)) {
        SPARCalculationParametersObject[['dates']] <-
          self$`dates`$toJSON()
      }

      SPARCalculationParametersObject
    },
    fromJSON = function(SPARCalculationParametersJson) {
      SPARCalculationParametersObject <- jsonlite::fromJSON(SPARCalculationParametersJson)
      if (!is.null(SPARCalculationParametersObject$`componentid`)) {
        self$`componentid` <- SPARCalculationParametersObject$`componentid`
      }
      if (!is.null(SPARCalculationParametersObject$`accounts`)) {
        self$`accounts` <- ApiClient$new()$deserializeObj(SPARCalculationParametersObject$`accounts`, "array[SPARIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(SPARCalculationParametersObject$`benchmark`)) {
        benchmarkObject <- SPARIdentifier$new()
        benchmarkObject$fromJSON(jsonlite::toJSON(SPARCalculationParametersObject$benchmark, auto_unbox = TRUE, digits = NA))
        self$`benchmark` <- benchmarkObject
      }
      if (!is.null(SPARCalculationParametersObject$`dates`)) {
        datesObject <- SPARDateParameters$new()
        datesObject$fromJSON(jsonlite::toJSON(SPARCalculationParametersObject$dates, auto_unbox = TRUE, digits = NA))
        self$`dates` <- datesObject
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`componentid`)) {
        sprintf(
        '"componentid":
          "%s"
                ',
        self$`componentid`
        )},
        if (!is.null(self$`accounts`)) {
        sprintf(
        '"accounts":
        [%s]
',
        paste(sapply(self$`accounts`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`benchmark`)) {
        sprintf(
        '"benchmark":
        %s
        ',
        jsonlite::toJSON(self$`benchmark`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`dates`)) {
        sprintf(
        '"dates":
        %s
        ',
        jsonlite::toJSON(self$`dates`$toJSON(), auto_unbox=TRUE, digits = NA)
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(SPARCalculationParametersJson) {
      SPARCalculationParametersObject <- jsonlite::fromJSON(SPARCalculationParametersJson)
      self$`componentid` <- SPARCalculationParametersObject$`componentid`
      self$`accounts` <- ApiClient$new()$deserializeObj(SPARCalculationParametersObject$`accounts`, "array[SPARIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      self$`benchmark` <- SPARIdentifier$new()$fromJSON(jsonlite::toJSON(SPARCalculationParametersObject$benchmark, auto_unbox = TRUE, digits = NA))
      self$`dates` <- SPARDateParameters$new()$fromJSON(jsonlite::toJSON(SPARCalculationParametersObject$dates, auto_unbox = TRUE, digits = NA))
      self
    }
  )
)
