% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_bs_parity}
\alias{eval_bs_parity}
\title{Examine Brier Score Parity of a Model}
\usage{
eval_bs_parity(
  data,
  outcome,
  group,
  probs,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable}

\item{group}{Name of the sensitive attribute}

\item{probs}{Predicted probabilities}

\item{confint}{Logical indicating whether to calculate confidence intervals}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{bootstraps}{Number of bootstraps to use for confidence intervals}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Logical; if TRUE (default), prints a textual summary of the
fairness evaluation. Only works if \code{confint} is TRUE.}
}
\value{
A list containing the following elements:
\itemize{
\item Brier Score for Group 1
\item Brier Score for Group 2
\item Difference in Brier Score
\item Ratio in Brier Score
If confidence intervals are computed (\code{confint = TRUE}):
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the difference in Brier Score
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the ratio in Brier Score
}
}
\description{
This function evaluates \emph{Brier Score Parity}, a fairness measure that checks whether the Brier score
(a measure of the calibration of probabilistic predictions) is similar across different groups. Brier score
parity ensures that the model's predicted probabilities are equally well calibrated across subpopulations.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.

# Evaluate Brier Score Parity
eval_bs_parity(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred"
)
}

}
\seealso{
\code{\link{eval_acc_parity}}, \code{\link{eval_cond_acc_equality}}, \code{\link{eval_pos_pred_parity}},  \code{\link{eval_neg_pred_parity}}
}
