% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ceteris_paribus_cutoff}
\alias{print.ceteris_paribus_cutoff}
\title{Print ceteris paribus cutoff}
\usage{
\method{print}{ceteris_paribus_cutoff}(x, ...)
}
\arguments{
\item{x}{\code{ceteris_paribus_cutoff} object}

\item{...}{other print parameters}
}
\description{
Print ceteris paribus cutoff
}
\examples{

data("german")

german <- german[1:500,]
y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

ceteris_paribus_cutoff(fobject, "female")
}
