% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_pivot.R
\name{roc_pivot}
\alias{roc_pivot}
\title{Reject Option based Classification pivot}
\usage{
roc_pivot(explainer, protected, privileged, cutoff = 0.5, theta = 0.1)
}
\arguments{
\item{explainer}{created with \code{\link[DALEX]{explain}}}

\item{protected}{factor, protected variables with subgroups as levels (sensitive attributes)}

\item{privileged}{factor/character, level in protected denoting privileged subgroup}

\item{cutoff}{numeric, threshold for all subgroups}

\item{theta}{numeric, variable specifies maximal euclidean distance to cutoff resulting ing label switch}
}
\value{
DALEX \code{explainer} with changed y_hat
}
\description{
Reject Option based Classifier is post-processing bias mitigation method. Method changes labels of favorable, privileged and close to cutoff observations to unfavorable
and the opposite for unprivileged observations (changing unfavorable and close to cutoff observations to favorable, more in details).
By this potentially wrongfully labeled observations are assigned different labels.
Note that in y in DALEX explainer 1 should indicate favorable outcome.
}
\details{
Method implemented implemented based on article (Kamiran, Karim, Zhang 2012). In original implementation labels should be switched. Due to specific DALEX methods
probabilities (y_hat) are assigned value in equal distance but other side of cutoff. The method changes explainers y_hat values in two cases.
\cr
1. When unprivileged subgroup is within (cutoff - theta, cutoff)\cr
2. When privileged subgroup is within (cutoff, cutoff + theta)\cr
}
\examples{

data("german")
data <- german
data$Age <- as.factor(ifelse(data$Age <= 25, "young", "old"))
y_numeric <- as.numeric(data$Risk) -1

lr_model     <- stats::glm(Risk ~., data = data, family = binomial())
lr_explainer <- DALEX::explain(lr_model, data = data[,-1], y = y_numeric)

fobject <- fairness_check(lr_explainer,
                          protected = data$Age,
                          privileged = "old")
plot(fobject)

lr_explainer_fixed <- roc_pivot(lr_explainer,
                                protected = data$Age,
                                privileged = "old")

fobject2 <- fairness_check(lr_explainer_fixed, fobject,
                           protected = data$Age,
                           privileged = "old",
                           label = "lr_fixed")
fobject2
plot(fobject2)
}
\references{
Kamiran, Karim, Zhang 2012 \url{https://ieeexplore.ieee.org/document/6413831/} ROC method
}
