% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairmodels.R
\name{plot_fairmodels}
\alias{plot_fairmodels}
\alias{plot_fairmodels.explainer}
\alias{plot_fairmodels.fairness_object}
\alias{plot_fairmodels.default}
\title{Plot fairmodels}
\usage{
plot_fairmodels(x, type, ...)

\method{plot_fairmodels}{explainer}(x, type = "fairness_check", ..., protected, privileged)

\method{plot_fairmodels}{fairness_object}(x, type = "fairness_check", ...)

\method{plot_fairmodels}{default}(x, type = "fairness_check", ...)
}
\arguments{
\item{x}{object created with \code{fairness_check} or with \code{\link[DALEX]{explain}}}

\item{type}{character, type of plot. Should match function name in fairmodels. Default is fairness_check.}

\item{...}{other parameters passed to fairmodels functions.}

\item{protected}{factor, vector containing sensitive attributes such as gender, race, etc...}

\item{privileged}{character/factor, level in factor denoting privileged subgroup}
}
\value{
\code{ggplot2} object
}
\description{
Easier access to all plots in fairmodels. Provide plot type (that matches to function name), pass additional parameters and plot.
}
\details{
types (function names) available:
\itemize{
\item fairness_check
\item stack_metrics
\item fairness_heatmap
\item fairness_pca
\item fairness_radar
\item group_metric
\item choose_metric
\item metric_scores
\item performance_and_fairness
\item all_cutoffs
\item ceteris_paribus_cutoff
}
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))
explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)

# works with explainer when protected and privileged are passed
plot_fairmodels(explainer_lm,
                type = "fairness_radar",
                protected = german$Sex,
                privileged = "male")

# or with fairness_object
fobject <- fairness_check(explainer_lm,
                          protected = german$Sex,
                          privileged = "male")

plot_fairmodels(fobject, type = "fairness_radar")
}
