% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarNoveltyDetector-class}
\alias{familiarNoveltyDetector-class}
\title{Novelty detector.}
\description{
A familiarNoveltyDetector object is a self-contained model that can be
applied to generate out-of-distribution predictions for instances in a
dataset.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the familiarNoveltyDetector object.}

\item{\code{learner}}{Learning algorithm used to create the novelty detector.}

\item{\code{model}}{The actual novelty detector trained using a specific algorithm,
e.g. a isolation forest from the `isotree` package.}

\item{\code{feature_info}}{List of objects containing feature information, e.g.,
name, class levels, transformation, normalisation and clustering
parameters.}

\item{\code{data_column_info}}{Data information object containing information
regarding identifier column names.}

\item{\code{conversion_parameters}}{Parameters used to convert raw output to
statistical probability of being out-of-distribution. Currently unused.}

\item{\code{hyperparameters}}{Set of hyperparameters used to train the detector.}

\item{\code{required_features}}{The set of features required for complete
reproduction, i.e. with imputation.}

\item{\code{model_features}}{The set of features that is used to train the detector.}

\item{\code{run_table}}{Run table for the data used to train the detector. Used
internally.}

\item{\code{is_trimmed}}{Flag that indicates whether the detector, stored in the
`model` slot, has been trimmed.}

\item{\code{trimmed_function}}{List of functions whose output has been captured prior
to trimming the model.}

\item{\code{project_id}}{Identifier of the project that generated the
familiarNoveltyDetector object.}

\item{\code{familiar_version}}{Version of the familiar package.}

\item{\code{package}}{Name of package(s) required to executed the detector itself,
e.g. `isotree`.}

\item{\code{package_version}}{Version of the packages mentioned in the `package`
  attribute.

Note that these objects do not contain any data concerning outcome, as this
not relevant for (prospective) out-of-distribution detection.}
}}

