/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jfm.lp.LPX;
import jfm.lp.Matrix;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatrixVariable {
    public final double upperBound;
    public final double lowerBound;
    public final LPX boundType;
    private int column;
    private double solution = 0.0;
    public final LPX varType;
    private final Types.ObjectiveType baseObjective;
    private final Map<Types.ObjectiveType, Double> objectiveCoefficients = new HashMap<Types.ObjectiveType, Double>();
    private String tag = "";

    public MatrixVariable(double coeff, double low, double up, LPX boundType_, LPX varType_, int col, Types.ObjectiveType obj_) {
        this.upperBound = up;
        this.lowerBound = low;
        this.boundType = boundType_;
        this.varType = varType_;
        this.column = col;
        this.objectiveCoefficients.put(obj_, coeff);
        this.baseObjective = obj_;
    }

    protected void addObjective(Types.ObjectiveType ot) {
        this.objectiveCoefficients.put(ot, 0.0);
    }

    double getCoefficientForObjective(Types.ObjectiveType ot) {
        return this.objectiveCoefficients.get((Object)ot);
    }

    double getPrimaryObjectiveCoefficient() {
        return this.objectiveCoefficients.get((Object)this.baseObjective);
    }

    Set<Types.ObjectiveType> objectivesSet() {
        return this.objectiveCoefficients.keySet();
    }

    public int column() {
        return this.column;
    }

    public double solution() {
        return this.solution;
    }

    public void setTag(String t) {
        this.tag = t;
    }

    public String tag() {
        return this.tag;
    }

    protected void setSolution(double val) {
        this.solution = val;
    }

    void setCoefficientForObjective(Types.ObjectiveType ot, double newvalue) {
        this.objectiveCoefficients.put(ot, newvalue);
    }

    void commitToMatrix(Matrix.PrimitiveMatrix pmatrix) {
        pmatrix.setVariable(this);
    }

    public boolean equals(Object other) {
        if (other instanceof MatrixVariable) {
            MatrixVariable oth = (MatrixVariable)other;
            if (oth.column == this.column) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.column;
    }
}

