% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_annual_flow_timing.R
\name{calc_annual_flow_timing}
\alias{calc_annual_flow_timing}
\title{Calculate annual flow timing}
\usage{
calc_annual_flow_timing(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  percent_total = c(25, 33.3, 50, 75),
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  transpose = FALSE
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required if
groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if present.
Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} argument.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{percent_total}{Numeric vector of percents of total annual flows to determine dates. Default \code{c(25,33.3,50,75)}.}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{transpose}{Logical value indicating if the results rows and columns are to be switched. Default \code{FALSE}.}
}
\value{
A tibble data frame with the following columns:
  \item{Year}{calendar or water year selected}
  \item{DoY_'n'pct_TotalQ}{day of year for each n-percent of total volumetric discharge}
  \item{Date_'n'pct_TotalQ}{date (YYYY-MM-DD) for each n-percent of total volumetric discharge}
  Default columns:
  \item{DoY_25pct_TotalQ}{day of year of 25-percent of total volumetric discharge}
  \item{Date_25pct_TotalQ}{date (YYYY-MM-DD) of 25-percent of total volumetric discharge}
  \item{DoY_33.3pct_TotalQ}{day of year of 33.3-percent of total volumetric discharge}
  \item{Date_33.3pct_TotalQ}{date (YYYY-MM-DD) of 33.3-percent of total volumetric discharge}
  \item{DoY_50pct_TotalQ}{day of year of 50-percent of total volumetric discharge}
  \item{Date_50pct_TotalQ}{date (YYYY-MM-DD) of 50-percent of total volumetric discharge}
  \item{DoY_75pct_TotalQ}{day of year of 75-percent of total volumetric discharge}
  \item{Date_75pct_TotalQ}{date (YYYY-MM-DD) of 75-percent of total volumetric discharge}
  Transposing data creates a column of 'Statistics' (just DoY, not Date values) and subsequent columns for each year selected.
}
\description{
Calculates annual the timing (day of year) and date of occurrence of portions of total annual flow of daily flow 
   values from a streamflow dataset. Calculates the statistics from all daily discharge values from all years with complete annual
   data, unless specified.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate annual flow timings with default percent of annual totals
calc_annual_flow_timing(station_number = "08NM116") 

# Calculate annual flow timings with custom percent of annual totals
calc_annual_flow_timing(station_number = "08NM116",
                        percent_total = 50)
                             
}
}
\references{
\itemize{
 \item{Barnett, T.P., Pierce, D.W., Hidalgo, H.G., Bonfils, C., Santer, B.D., Das, T., Bala, G., Wood, A.W.,
       Nozawa, T., Mirin, A.A., Cayan, D.R., Dettinger, M.D., 2008. Human-Induced Clanges in the Hydrology of 
       the Western United States. Science 319, 1080-1083.}
       }
}
