% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_flow_duration.R
\name{plot_flow_duration}
\alias{plot_flow_duration}
\title{Plot flow duration curves}
\usage{
plot_flow_duration(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = 1,
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  complete_years = FALSE,
  custom_months,
  custom_months_label,
  ignore_missing = FALSE,
  months = 1:12,
  include_longterm = TRUE,
  log_discharge = TRUE,
  include_title = FALSE
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required if
groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if present.
Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} argument.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
('left'), last ('right), or middle ('center') day of the rolling n-day group of observations. Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{custom_months}{Numeric vector of months to combine to summarize (ex. \code{6:8} for Jun-Aug). Adds results to the end of table.
If wanting months that overlap calendar years (ex. Oct-Mar), choose water_year_start that begins before the first 
month listed. Leave blank for no custom month summary.}

\item{custom_months_label}{Character string to label custom months. For example, if choosing months 7:9  you may choose 
"Summer" or "Jul-Sep". Default \code{"Custom-Months"}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only statistics from time periods 
with no missing dates will be returned. Default \code{FALSE}.}

\item{months}{Numeric vector of month curves to plot. NA if no months required. Default \code{1:12}.}

\item{include_longterm}{Logical value indicating whether to include longterm curve of all data. Default \code{TRUE}.}

\item{log_discharge}{Logical value to indicate plotting the discharge axis (Y-axis) on a logarithmic scale. Default \code{FALSE}.}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}
}
\value{
A list of ggplot2 objects with the following for each station provided:
  \item{Flow_Duration}{a plot that contains flow duration curves for each month, long-term, and (option) customized months}
}
\description{
Plots flow duration curves, percent time a flow value is equalled or exceeded, for a streamflow dataset. Plots 
   statistics from all daily discharge values from all years, unless specified. Data calculated using calc_longterm_stats() 
   function then converted for plotting.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot flow durations using a data frame and data argument with defaults
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
plot_flow_duration(data = flow_data,
                    start_year = 1980)

# Plot flow durations using station_number argument with defaults
plot_flow_duration(station_number = "08NM116",
                   start_year = 1980)

# Plot flow durations and add custom stats for July-September
plot_flow_duration(station_number = "08NM116",
                   start_year = 1980,
                   custom_months = 7:9,
                   custom_months_label = "Summer")
                   
}
}
\seealso{
\code{\link{calc_longterm_daily_stats}}
}
