% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_cols.R
\name{dummy_columns}
\alias{dummy_columns}
\title{Fast creation of dummy variables}
\usage{
dummy_columns(.data, select_columns = NULL, remove_first_dummy = FALSE)
}
\arguments{
\item{.data}{An object with the data set you want to make dummy columns from.}

\item{select_columns}{Vector of column names that you want to create dummy variables from.
If NULL (default), uses all character and factor columns.}

\item{remove_first_dummy}{Removes the first dummy of every variable that only n-1 Dummies remain.
This avoids multicollinearity issues in models.}
}
\description{
dummy_columns() quickly creates dummy (binary) columns from character and
factor type columns in the inputted data. This function is useful for
statistical analysis when you want binary columns rather than
character columns.
}
\examples{
crime <- data.frame(city = c("SF", "SF", "NYC"),
    year = c(1990, 2000, 1990),
    crime = 1:3)
dummy_cols(crime)
# Include year column
dummy_cols(crime, select_columns = c("city", "year"))
# Remove first dummy for each pair of dummy columns made
dummy_cols(crime, select_columns = c("city", "year"),
    remove_first_dummy = TRUE)
}
\seealso{
\code{\link{dummy_rows}} For creating dummy rows

Other dummy functions: \code{\link{dummy_cols}},
  \code{\link{dummy_rows}}
}
