% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dedupeMatches.R
\name{dedupeMatches}
\alias{dedupeMatches}
\title{dedupeMatches}
\usage{
dedupeMatches(matchesA, matchesB, EM,
matchesLink, varnames, stringdist.match, partial.match,
linprog, stringdist.method, cut.a = 0.92, cut.p = 0.88,
jw.weight)
}
\arguments{
\item{matchesA}{A dataframe of the matched observations in
dataset A, with all variables used to inform the match.}

\item{matchesB}{A dataframe of the matched observations in
dataset B, with all variables used to inform the match.}

\item{EM}{The EM object from \code{emlinkMARmov()}}

\item{matchesLink}{The output from \code{matchesLink()}}

\item{varnames}{A vector of variable names to use for matching.
Must be present in both matchesA and matchesB.}

\item{stringdist.match}{A vector of booleans, indicating whether to use
string distance matching when determining matching patterns on
each variable. Must be same length as varnames.}

\item{partial.match}{A vector of booleans, indicating whether to include
a partial matching category for the string distances. Must be same length
as varnames. Default is FALSE for all variables.}

\item{linprog}{Whether to implement Winkler's linear programming solution to the deduplication
problem. Default is false.}

\item{stringdist.method}{String distance method for calculating similarity, options are: "jw" Jaro-Winkler (Default), "jaro" Jaro, and "lv" Edit}

\item{cut.a}{Lower bound for full string-distance match, ranging between 0 and 1. Default is 0.92}

\item{cut.p}{Lower bound for partial string-distance match, ranging between 0 and 1. Default is 0.88}

\item{jw.weight}{Parameter that describes the importance of the first characters of a string (only needed if stringdist.method = "jw"). Default is .10}
}
\value{
\code{dedupeMatches()} returns a list containing the following elements:
\item{matchesA}{A deduped version of matchesA}
\item{matchesB}{A deduped version of matchesB}
\item{EM}{A deduped version of the EM object}
}
\description{
Dedupe matched dataframes.
}
\author{
Ted Enamorado <ted.enamorado@gmail.com> and Ben Fifield <benfifield@gmail.com>
}

