% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fastLink}
\alias{summary.fastLink}
\title{Get summaries of fastLink() objects}
\usage{
\method{summary}{fastLink}(object, num.comparisons = 1,
thresholds = c(.95, .85, .75), weighted = TRUE, digits = 3, ...)
}
\arguments{
\item{object}{Either a single `fastLink` or `fastLink.EM` object, or a list of `fastLink` or `fastLink.EM` objects
to be aggregated together produced  by `aggregateEM`.}

\item{num.comparisons}{The number of comparisons attempted for each observation in the across-geography match step.
A correction factor to avoid multiple-counting. Default is NULL}

\item{thresholds}{A vector of posterior probabilities to calculate the summary statistics.}

\item{weighted}{Whether to weight the cross-geography matches on FDR and FNR.}

\item{digits}{How many digits to include in summary object. Default is 3.}

\item{...}{Further arguments to be passed to \code{summary.fastLink()}.}
}
\description{
\code{summary.fastLink()} calculates and outputs FDR, FNR, match counts, and match rates for
estimated matches from a fastLink() object.
}

