% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Corn}
\alias{Corn}
\title{Corn Yield}
\format{
A data frame with 11 observations on the following 2 variables.
\itemize{ \item{reg}{ yield of regular corn (lbs/acre)}
\item{kiln}{ yield of kiln-dried corn (lbs/acre)} }
}
\source{
These data are also available at DASL, the data and story library
(\url{https://dasl.datadescription.com/}).
}
\description{
William Gosset analyzed data from an experiment comparing the yield of
regular and kiln-dried corn.
}
\details{
Gosset (Student) reported on the results of seeding plots with two different
kinds of seed. Each type of seed (regular and kiln-dried) was planted in
adjacent plots, accounting for 11 pairs of "split" plots.
}
\examples{

Corn2 <- stack(Corn)
names(Corn2) <- c('yield','treatment')
lm(yield ~ treatment, data = Corn2)
t.test(yield ~ treatment, data = Corn2)
t.test(Corn$reg, Corn$kiln)

}
\references{
W.S. Gosset, "The Probable Error of a Mean," Biometrika, 6
(1908), pp 1-25.
}
\keyword{datasets}
