% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fastcmh.R
\name{FastCMH}
\alias{FastCMH}
\title{Run the FastCMH algorithm}
\usage{
FastCMH(folder = NULL, data = NULL, label = NULL, cov = NULL,
  alpha = 0.05, Lmax = 0, showProcessing = FALSE, saveAllPvals = FALSE,
  doFDR = FALSE, useDependenceFDR = FALSE, saveToFile = FALSE,
  saveFilename = "fastcmhresults.RData", saveFolder = NULL)
}
\arguments{
\item{folder}{The folder in which the data is saved. If the any of 'data', 'label' and 'pvalue' arguments are not specified, then filenames must have following a naming convention inside the folder: data file is "data.txt" (i.e. full path is "folder/data.txt"), phenotype label file is "label.txt", and covariate label file is "cov.txt". More details on the structure of these files is given below, or the user can use the 'makeSampleData' function to see an example of the correct data formats. If folder="/data/", the data in fastcmh/inst/extdata is used.}

\item{data}{The filename for the data file. Default is NULL. The data file must be an L x n txt file containing only 0s and 1s, which are space-separated in each row, while each row is on a separate newline.}

\item{label}{The filename for the phenotype label file. Default is NULL. The label file should consist of a single column (i.e. each row is on a separate line) of 0s and 1s.}

\item{cov}{The filename for the covariate label file. Default is NULL. The cov filecontains a single column of positive integers. The first row, containing value n_1, specifies that the first n_1 columns have covariate value 1; the second row, containing n_2, specifies that the next n_2 rows have covariate value 2, etc.}

\item{alpha}{The value of the FWER; must be a number between 0 and 1. Default is 0.05.}

\item{Lmax}{The maximum length of significant intervals which is considered. Must be a non-negative integer. For example, Lmax=10 searches for significant intervals up to length 10. Setting Lmax=0 will search for significant intervals up to any length (with algorithm pruning appropriately). Default is Lmax=0.}

\item{showProcessing}{A flag which will turn printing to screen on/off. Default is FALSE (which is "off")}

\item{saveAllPvals}{A flag which controls whether or not all the intervals (less than minimum attainable pvalue) will be returned. Default is FALSE (which is "no, do notreturn all intervals")}

\item{doFDR}{A flag which controls whether or not Gilbert's Tarone FDR procedure (while accounting for positive regression dependence) is performed. Default is FALSE (which is "no, do not do FDR")}

\item{useDependenceFDR}{A flag which controls whether or not Gilbert's Tarone FDR procedure uses the dependent formulation by Benjamini and Yekutieli (2001), which further adjusts alpha by dividing by the harmonic mean. This flag is only used if doFDR==TRUE. Default is FALSE.}

\item{saveToFile}{A flag which controls whether or not the results are saved to file. By default, saveToFile=FALSE, and the data frame is returned in R. See the examples below.}

\item{saveFilename}{A string which gives the filename to which the output is saved (needs to have saveToFile=TRUE) as an RData file. Default is "fastcmhresults.RData".}

\item{saveFolder}{A string which gives the path to which the output will be saved (needs to have saveToFile=TRUE). Default is "./".}
}
\description{
This function runs the FastCMH algorithm on a particular data set.
}
\section{Details}{

This function runs the FastCMH algorithm on a particular data set in order to discover intervals that are statistically significantly associated with a particular label, while accounting for categorical covariates.
The user must either supply the folder, which contains files named "data.txt", "label.txt" and "cov.txt", or the non-default filenames must be specified individually. See the descriptions of arguments "data", "label" and "cov" to see the format of the input files, or make a small sample data file using the makeSampleData() function.
By default, filtered results are provided. The user also has the option of using an FDR procedure rather than the standard FWER-preserving procedure.
}

\section{Value}{

FastCMH will return a list if saveToFile=FALSE (default setting), otherwise it will save the list in an .RData file. The fields of the list are:

sig: a dataframe listing the significant intervals, after filterting. Columns 'start', 'end' and 'pvalue' indicate the start and end points of the interval (inclusive), and the p-value for that interval

unfiltered: a dataframe listing all the significant intervals before filtering. The filtering compares the overlapping intervals and returns the interval with the smallest p-value in each cluster of overlapping intervals. Dataframe has has structure as sig

fdr: (if doFDR==TRUE) significant intervals using Gilbert's FDR-Tarone procedure, after filtering. Dataframe has same structure as sig

unfilteredFdr: (if doFDR==TRUE) a dataframe listing all the significant intervals before filtering. See description of 'unfiltered'
}

\section{Author(s)}{


allTestablle: (if saveAllPvals==TRUE) a dataframe listing all the testable intervals, many of which will not be significant. Dataframe has same structure as sig

histObs: Together with histFreq gives a histogram of maximum attainable CMH statistics

histFreq: Histogram of maximum attainable CMH statistics (only reliable in the testable range)

summary: a character string summarising the results. Use 'cat(...$summary)' to print the results with the correct indentation/new lines.

timing: a list containing (i) details, a character string summarising the runtime values for the experiment - use cat(...$details) for correct indentation, etc. (ii) exec, the total execution time. (iii) init, the time to initialise the objects. (iv) fileIO, the time to read the input files. (v) compSigThresh, the time to compute the significance threshold. (vi) compSigInt, the time to compute the significant intervals. (vii) peakMemUsage, a value indicating the total amount of memory used. However, in this version, the value will always be 0.



Felipe Llinares Lopez, Dean Bodenham
}

\section{See Also}{

'makeSampleData'
}

\section{References}{


Gilbert, P. B. (2005) A modified false discovery rate multipl-comparisons procedure for discrete data, applied to human immunodeficiency virus genetics. Journal of the Royal Statistical Society: Series C (Applied Statistics), 54(1), 143-158.

Benjamini, Y., Yekutieli, D. (2001). The control of the false discovery rate in multiple testing under dependency. Annals of statistics, 29(4), 1165-1188.
}
\examples{
#Example with default naming convention used for data, label and cov files
# Note: using "/data/" as the argument for folder
#       accesses the data/ directory in the fastcmh package folder
mylist <- FastCMH("/data/")

#Example where the progress will be shown
mylist <- FastCMH(folder="/data/", showProcessing=TRUE)

#Example where many parameters are specified
mylist <- FastCMH(folder="/data/", data="data2.txt", alpha=0.01, Lmax=7)

#Example where Gilbert's Tarone-FDR procedure is used
mylist <- FastCMH("/data/", doFDR=TRUE)

#Example where FDR procedure takes some dependence structures into account
mylist <- FastCMH("/data/", doFDR=TRUE, useDependenceFDR=TRUE)

#Example where the data frame is saved to file
FastCMH("/data/", saveToFile=TRUE, saveFolder="./", saveFilename="output.RData")
}

