% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_class.R
\name{plot.fastcpd}
\alias{plot.fastcpd}
\alias{plot,fastcpd,missing-method}
\title{Plot the data and the change points for a \linkS4class{fastcpd} object}
\usage{
\method{plot}{fastcpd}(
  x,
  color_max_count = Inf,
  data_point_alpha = 0.8,
  data_point_linewidth = 0.5,
  data_point_size = 1,
  legend_position = "none",
  panel_background = ggplot2::element_blank(),
  panel_border = ggplot2::element_rect(fill = NA, colour = "grey20"),
  panel_grid_major = ggplot2::element_line(colour = "grey98"),
  panel_grid_minor = ggplot2::element_line(colour = "grey98"),
  segment_separator_alpha = 0.8,
  segment_separator_color = "grey",
  segment_separator_linetype = "dashed",
  strip_background = ggplot2::element_rect(fill = "grey85", colour = "grey20"),
  xlab = NULL,
  ylab = NULL,
  ...
)

\S4method{plot}{fastcpd,missing}(
  x,
  color_max_count = Inf,
  data_point_alpha = 0.8,
  data_point_linewidth = 0.5,
  data_point_size = 1,
  legend_position = "none",
  panel_background = ggplot2::element_blank(),
  panel_border = ggplot2::element_rect(fill = NA, colour = "grey20"),
  panel_grid_major = ggplot2::element_line(colour = "grey98"),
  panel_grid_minor = ggplot2::element_line(colour = "grey98"),
  segment_separator_alpha = 0.8,
  segment_separator_color = "grey",
  segment_separator_linetype = "dashed",
  strip_background = ggplot2::element_rect(fill = "grey85", colour = "grey20"),
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{fastcpd} object.}

\item{color_max_count}{Maximum number of colors to use for the plotting
of segments.}

\item{data_point_alpha}{Alpha of the data points.}

\item{data_point_linewidth}{Linewidth of the data points.}

\item{data_point_size}{Size of the data points.}

\item{legend_position}{Position of the legend.}

\item{panel_background}{Background of the panel.}

\item{panel_border}{Border of the panel.}

\item{panel_grid_major}{Major grid lines of the panel.}

\item{panel_grid_minor}{Minor grid lines of the panel.}

\item{segment_separator_alpha}{Alpha of the segment separator lines.}

\item{segment_separator_color}{Color of the segment separator lines.}

\item{segment_separator_linetype}{Linetype of the segment separator lines.}

\item{strip_background}{Background of the strip.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{...}{Ignored.}
}
\value{
No return value, called for plotting.
}
\description{
Plot the data and the change points for a \linkS4class{fastcpd} object
}
\examples{
set.seed(1)
p <- 1
x <- mvtnorm::rmvnorm(300, rep(0, p), diag(p))
theta_0 <- matrix(c(1, -1, 0.5))
y <- c(
  x[1:100, ] * theta_0[1, ] + rnorm(100, 0, 1),
  x[101:200, ] * theta_0[2, ] + rnorm(100, 0, 1),
  x[201:300, ] * theta_0[3, ] + rnorm(100, 0, 1)
)
result <- fastcpd.lm(cbind(y, x), r.clock = "fastcpd_profiler")
summary(result)
plot(result)

library(RcppClock)
plot(fastcpd_profiler)
}
