# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Initialize \code{fastcpd_parameters}.
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param p Number of parameters.
#' @param family Family of the model.
#' @param segment_count Number of segments.
#' @param cost Cost function.
#' @param winsorise_minval Minimum value to be winsorised.
#' @param winsorise_maxval Maximum value to be winsorised.
#' @param epsilon Epsilon to avoid numerical issues.
#' @param vanilla_percentage Percentage of vanilla gradient descent.
#' @param beta Beta for the momentum.
#' @keywords internal
#'
#' @noRd
#' @return A list containing new values of \code{fastcpd_parameters}.
init_fastcpd_parameters <- function(data, p, family, segment_count, cost, winsorise_minval, winsorise_maxval, epsilon, vanilla_percentage, beta) {
    .Call(`_fastcpd_init_fastcpd_parameters`, data, p, family, segment_count, cost, winsorise_minval, winsorise_maxval, epsilon, vanilla_percentage, beta)
}

#' Update the parameters related to fastcpd.
#' This function is not meant to be called directly by the user.
#'
#' @param fastcpd_parameters A list containing the parameters related to
#'   fastcpd.
#' @param data A data frame containing the data to be segmented.
#' @param t Current iteration.
#' @param i Index of the current data in the whole data set.
#' @param k Number of epochs in SGD.
#' @param tau Start of the current segment.
#' @param lambda Lambda for L1 regularization.
#' @param family Family of the model.
#' @param cost_gradient Gradient for custom cost function.
#' @param cost_hessian Hessian for custom cost function.
#' @param r_t_set Set of r_t values for the current iteration.
#' @param p Number of parameters.
#' @param momentum_coef Momentum coefficient to be applied to the current
#'   momentum.
#' @param min_prob Minimum probability to avoid numerical issues.
#' @param winsorise_minval Minimum value to be winsorised.
#' @param winsorise_maxval Maximum value to be winsorised.
#' @param epsilon Epsilon to avoid numerical issues.
#' @keywords internal
#'
#' @noRd
#' @return A list containing new values of \code{fastcpd_parameters}.
update_fastcpd_parameters <- function(fastcpd_parameters, data, t, i, k, tau, lambda, family, cost_gradient, cost_hessian, r_t_set, p, momentum_coef, min_prob, winsorise_minval, winsorise_maxval, epsilon) {
    .Call(`_fastcpd_update_fastcpd_parameters`, fastcpd_parameters, data, t, i, k, tau, lambda, family, cost_gradient, cost_hessian, r_t_set, p, momentum_coef, min_prob, winsorise_minval, winsorise_maxval, epsilon)
}

#' Append new values to \code{fastcpd_parameters}.
#' This function is not meant to be called directly by the user.
#'
#' @param fastcpd_parameters A list containing the parameters related to
#'   fastcpd.
#' @param vanilla_percentage Percentage of vanilla gradient descent.
#' @param data A data frame containing the data to be segmented.
#' @param t Current iteration.
#' @param family Family of the model.
#' @param winsorise_minval Minimum value to be winsorised.
#' @param winsorise_maxval Maximum value to be winsorised.
#' @param p Number of parameters.
#' @param epsilon Epsilon to avoid numerical issues.
#' @keywords internal
#'
#' @noRd
#' @return A list containing new values of \code{fastcpd_parameters}.
append_fastcpd_parameters <- function(fastcpd_parameters, vanilla_percentage, data, t, family, winsorise_minval, winsorise_maxval, p, epsilon) {
    .Call(`_fastcpd_append_fastcpd_parameters`, fastcpd_parameters, vanilla_percentage, data, t, family, winsorise_minval, winsorise_maxval, p, epsilon)
}

#' Solve logistic/poisson regression using Gradient Descent Extension to the
#' multivariate case
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param theta Estimate of the parameters. If null, the function will estimate
#'   the parameters.
#' @param family Family of the model.
#' @param lambda Lambda for L1 regularization. Only used for lasso.
#' @param cv Whether to perform cross-validation to find the best lambda.
#' @param start Starting point for the optimization for warm start.
#' @keywords internal
#' @importFrom glmnet glmnet cv.glmnet predict.glmnet
#' @importFrom fastglm fastglm
#'
#' @noRd
#' @return Negative log likelihood of the corresponding data with the given
#'   family.
negative_log_likelihood <- function(data, theta, family, lambda, cv = FALSE, start = NULL) {
    .Call(`_fastcpd_negative_log_likelihood`, data, theta, family, lambda, cv, start)
}

#' Function to calculate the gradient at the current data.
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param theta Estimated theta from the previous iteration.
#' @param family Family of the model.
#' @keywords internal
#'
#' @noRd
#' @return Gradient at the current data.
cost_update_gradient <- function(data, theta, family) {
    .Call(`_fastcpd_cost_update_gradient`, data, theta, family)
}

#' Function to calculate the Hessian matrix at the current data.
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param theta Estimated theta from the previous iteration.
#' @param family Family of the model.
#' @param min_prob Minimum probability to avoid numerical issues.
#' @keywords internal
#'
#' @noRd
#' @return Hessian at the current data.
cost_update_hessian <- function(data, theta, family, min_prob) {
    .Call(`_fastcpd_cost_update_hessian`, data, theta, family, min_prob)
}

#' Update the cost values for the segmentation.
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param theta_hat Estimated theta from the previous iteration.
#' @param theta_sum Sum of estimated theta from the previous iteration.
#' @param hessian Hessian matrix from the previous iteration.
#' @param tau Start of the current segment.
#' @param i Index of the current data in the whole data set.
#' @param k Number of epochs in SGD.
#' @param family Family of the model.
#' @param momentum Momentum from the previous iteration.
#' @param momentum_coef Momentum coefficient to be applied to the current
#'   momentum.
#' @param epsilon Epsilon to avoid numerical issues. Only used for binomial and
#'   poisson.
#' @param min_prob Minimum probability to avoid numerical issues. Only used for
#'   poisson.
#' @param winsorise_minval Minimum value to be winsorised. Only used for
#'   poisson.
#' @param winsorise_maxval Maximum value to be winsorised. Only used for
#'   poisson.
#' @param lambda Lambda for L1 regularization. Only used for lasso.
#' @param cost_gradient Gradient for custom cost function.
#' @param cost_hessian Hessian for custom cost function.
#' @keywords internal
#' @importFrom DescTools Winsorize
#'
#' @noRd
#' @return A list containing new values of \code{theta_hat}, \code{theta_sum},
#'   \code{hessian}, and \code{momentum}.
cost_update <- function(data, theta_hat, theta_sum, hessian, tau, i, k, family, momentum, momentum_coef, epsilon, min_prob, winsorise_minval, winsorise_maxval, lambda, cost_gradient, cost_hessian) {
    .Call(`_fastcpd_cost_update`, data, theta_hat, theta_sum, hessian, tau, i, k, family, momentum, momentum_coef, epsilon, min_prob, winsorise_minval, winsorise_maxval, lambda, cost_gradient, cost_hessian)
}

#' Update \code{theta_hat}, \code{theta_sum}, and \code{hessian}.
#' This function is not meant to be called directly by the user.
#'
#' @param family Family of the model.
#' @param p Number of parameters.
#' @param data_segment A data frame containing a segment of the data.
#' @param cost Cost function.
#' @param lambda Lambda for L1 regularization.
#' @param cv Whether to perform cross-validation to find the best lambda.
#' @keywords internal
#'
#' @noRd
#' @return A list containing new values of \code{theta_hat}, \code{theta_sum},
#'   and \code{hessian}.
cost_optim <- function(family, p, data_segment, cost, lambda, cv) {
    .Call(`_fastcpd_cost_optim`, family, p, data_segment, cost, lambda, cv)
}

#' Implementation of the fastcpd algorithm.
#' This function is not meant to be called directly by the user.
#'
#' @param data A data frame containing the data to be segmented.
#' @param beta Initial cost value.
#' @param segment_count Number of segments for initial guess.
#' @param trim Trimming for the boundary change points.
#' @param momentum_coef Momentum coefficient to be applied to each update.
#' @param k Function on number of epochs in SGD.
#' @param family Family of the models. Can be "binomial", "poisson", "lasso" or
#'     "gaussian". If not provided, the user must specify the cost function and
#'     its gradient (and Hessian).
#' @param epsilon Epsilon to avoid numerical issues. Only used for binomial and
#'     poisson.
#' @param min_prob Minimum probability to avoid numerical issues. Only used for
#'     poisson.
#' @param winsorise_minval Minimum value to be winsorised. Only used for
#'     poisson.
#' @param winsorise_maxval Maximum value to be winsorised. Only used for
#'     poisson.
#' @param p Number of parameters to be estimated.
#' @param cost Cost function to be used. If not specified, the default is
#'     the negative log-likelihood for the corresponding family.
#' @param cost_gradient Gradient for custom cost function.
#' @param cost_hessian Hessian for custom cost function.
#' @param cp_only Whether to return only the change points or with the cost
#'     values for each segment. If family is not provided or set to be
#'     "custom", this parameter will be set to be true.
#' @param vanilla_percentage How many of the data should be processed through
#'     vanilla PELT. Range should be between 0 and 1. If set to be 0, all data
#'     will be processed through sequential gradient descnet. If set to be 1,
#'     all data will be processed through vaniall PELT. If the cost function
#'     have an explicit solution, i.e. does not depend on coefficients like
#'     the mean change case, this parameter will be set to be 1.
#' @keywords internal
#'
#' @noRd
#' @return A list containing the change points and the cost values for each
#'   segment.
fastcpd_impl <- function(data, beta, segment_count, trim, momentum_coef, k, family, epsilon, min_prob, winsorise_minval, winsorise_maxval, p, cost, cost_gradient, cost_hessian, cp_only, vanilla_percentage) {
    .Call(`_fastcpd_fastcpd_impl`, data, beta, segment_count, trim, momentum_coef, k, family, epsilon, min_prob, winsorise_minval, winsorise_maxval, p, cost, cost_gradient, cost_hessian, cp_only, vanilla_percentage)
}

