% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastdid.R
\name{fastdid}
\alias{fastdid}
\title{Fast Staggered DID Estimation}
\usage{
fastdid(
  data,
  timevar,
  cohortvar,
  unitvar,
  outcomevar,
  control_option = "both",
  result_type = "group_time",
  balanced_event_time = NA,
  control_type = "ipw",
  allow_unbalance_panel = FALSE,
  boot = FALSE,
  biters = 1000,
  cband = FALSE,
  alpha = 0.05,
  weightvar = NA,
  clustervar = NA,
  covariatesvar = NA,
  varycovariatesvar = NA,
  copy = TRUE,
  validate = TRUE,
  anticipation = 0,
  base_period = "universal",
  exper = NULL,
  full = FALSE,
  parallel = FALSE,
  cohortvar2 = NA,
  event_specific = TRUE,
  double_control_option = "both"
)
}
\arguments{
\item{data}{data.table, the dataset.}

\item{timevar}{character, name of the time variable.}

\item{cohortvar}{character, name of the cohort (group) variable.}

\item{unitvar}{character, name of the unit (id) variable.}

\item{outcomevar}{character vector, name(s) of the outcome variable(s).}

\item{control_option}{character, control units used for the DiD estimates, options are "both", "never", or "notyet".}

\item{result_type}{character, type of result to return, options are "group_time", "time", "group", "simple", "dynamic" (time since event), "group_group_time", or "dynamic_stagger".}

\item{balanced_event_time}{number, max event time to balance the cohort composition.}

\item{control_type}{character, estimator for controlling for covariates, options are "ipw" (inverse probability weighting), "reg" (outcome regression), or "dr" (doubly-robust).}

\item{allow_unbalance_panel}{logical, allow unbalance panel as input or coerce dataset into one.}

\item{boot}{logical, whether to use bootstrap standard error.}

\item{biters}{number, bootstrap iterations. Default is 1000.}

\item{cband}{logical, whether to use uniform confidence band or point-wise.}

\item{alpha}{number, the significance level. Default is 0.05.}

\item{weightvar}{character, name of the weight variable.}

\item{clustervar}{character, name of the cluster variable.}

\item{covariatesvar}{character vector, names of time-invariant covariate variables.}

\item{varycovariatesvar}{character vector, names of time-varying covariate variables.}

\item{copy}{logical, whether to copy the dataset.}

\item{validate}{logical, whether to validate the dataset.}

\item{anticipation}{number, periods with anticipation.}

\item{base_period}{character, type of base period in pre-preiods, options are "universal", or "varying".}

\item{exper}{list, arguments for experimental features.}

\item{full}{logical, whether to return the full result (influence function, call, weighting scheme, etc,.).}

\item{parallel}{logical, whether to use parallization on unix system.}

\item{cohortvar2}{character, name of the second cohort (group) variable.}

\item{event_specific}{logical, whether to recover target treatment effect or use combined effect.}

\item{double_control_option}{character, control units used for the double DiD, options are "both", "never", or "notyet".}
}
\value{
A data.table containing the estimated treatment effects and standard errors or a list of all results when `full == TRUE`.
}
\description{
Performs Difference-in-Differences (DID) estimation.
}
\details{
`balanced_event_time` is only meaningful when `result_type == "dynamic`.

`result_type` as `group-group-time` and `dynamic staggered` is only meaningful when using double did.

`biter` and `clustervar` is only used when `boot == TRUE`.
}
\examples{
# simulated data
simdt <- sim_did(1e+02, 10, cov = "cont", second_cov = TRUE, second_outcome = TRUE, seed = 1)
dt <- simdt$dt

#basic call
result <- fastdid(data = dt, timevar = "time", cohortvar = "G", 
                  unitvar = "unit", outcomevar = "y",  
                  result_type = "group_time")

}
\keyword{computation}
\keyword{data}
\keyword{did}
\keyword{difference-in-differences}
\keyword{estimation}
\keyword{fast}
\keyword{panel}
