% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00a_GLocation_class.r, R/00b_GSpatial_class.r,
%   R/00c_GRegion_class.r, R/00d_GRaster_class.r, R/00e_GVector_class.r
\docType{class}
\name{GLocation-class}
\alias{GLocation-class}
\alias{GLocation}
\alias{GSpatial-class}
\alias{GSpatial}
\alias{GRegion-class}
\alias{GRegion}
\alias{GRaster-class}
\alias{GRaster}
\alias{GVector-class}
\alias{GVector}
\title{Classes for fasterRaster sessions, regions, rasters, and vectors}
\value{
An object of class \code{GLocation}, \code{GSpatial}, \code{GRegion}, \code{GRaster}, or \code{GVector}.
}
\description{
The \code{G}-suite of S4 classes contain pointers to \strong{GRASS} objects or metadata about the current \strong{GRASS} session. Most users will manipulate objects using these classes, but do not need to know the details.
\itemize{
\item The \code{GLocation} class stores information about the \strong{GRASS} "project"/"location"(see \code{vignette("projects_mapsets", package = "fasterRaster")}), and coordinate reference system. Contained by all the rest.
\item The \code{GSpatial} class contains the \code{GLocation} class and stores information about spatial objects (extent, topology) plus the name of the file representing it in \strong{GRASS} (its \code{source}). Contained by \code{GRegion}, \code{GRaster}, and \code{GVector}.
\item The \code{GRegion} class contains the \code{GSpatial} class and stores information about grids (dimensions and resolution). They do have \code{sources}, but these are not used (they're always \code{NA}). Contained by \code{GRaster}. The \code{GRegion} corresponds to \strong{GRASS} "regions", though \code{GRegion} objects are not actually pointers to \strong{GRASS} "region" files (see \code{vignette("regions", package = "fasterRaster")}).
\item The \code{GRaster} class contains the \code{GRegion} class and represents rasters. It stores information on number of layers, categories, min/max values, and user-friendly names. Categorical \code{GRaster}s are associated with a "levels" table for representing categorical data (e.g., wetlands, forest, etc.).
\item The \code{GVector} class contains the \code{GSpatial} class and represents spatial vectors. It may or may not have an associated \code{data.table} (i.e., a \code{data.frame}), which contains metadata about each geometry in the vector.
}
}
\section{Slots}{

\describe{
\item{\code{location}}{Character (all classes): The \strong{GRASS} "project"/"location" of the object. The default value is \code{default}. Can be obtained using the hidden function \code{.location()}. See \code{vignette("projects_mapsets", package = "fasterRaster")}.}

\item{\code{mapset}}{Character (all classes): The \strong{GRASS} "mapset". Default value is \code{PERMANENT}. Typically hidden to users. Can be obtained using the hidden function \code{.mapset()}. See \code{vignette("projects_mapsets", package = "fasterRaster")}.}

\item{\code{workDir}}{Character (all classes): Directory in which \strong{GRASS} stores files.}

\item{\code{topology}}{Character (\code{GSpatial} objects, including \code{GRegion}s, \code{GRaster}s, and \code{GVector}s): Valid values are \verb{2D} (2-dimensional--most rasters and vectors) or \verb{3D} (3-dimensional--e.g., LIDAR data). Can be obtained using \code{\link[=topology]{topology()}}.}

\item{\code{sources}}{Character (\code{GRaster}s and \code{GVector}s): Name of the object in \strong{GRASS}. These are typically made on-the-fly and provide the pointer to the object from \strong{R} to \strong{GRASS}. Changing them manually will break the connection. Can be obtained using \code{\link[=sources]{sources()}}.}

\item{\code{names}}{Character  (\code{GRaster}s only): Name of a raster or each raster layer in. Can be obtained using \code{\link[=names]{names()}}.}

\item{\code{crs}}{Character (all classes): Coordinate reference systems string (preferably in WKT2 format). Can be obtained using \code{\link[=crs]{crs()}} or \code{\link[=st_crs]{st_crs()}}.}

\item{\code{projection}}{Character: The \strong{GRASS} "projection" for a \code{GRaster} or \code{GVector}. Can be obtained using \code{.projection()}.}

\item{\code{dimensions}}{Dimensions:
\itemize{
\item \code{GRegion}s and \code{GRaster}s: Vector of three integers indicating number of rows, columns, and depths (for 3D objects). Can be obtained using \code{\link[=dim]{dim()}}, plus \code{\link[=nrow]{nrow()}}, \code{\link[=ncol]{ncol()}}, and \code{\link[=ndepth]{ndepth()}}.
\item \code{GVectors}s: Vector of two integers indicating number of geometries and number of fields. Can be obtained using \code{\link[=dim]{dim()}}, plus \code{\link[=nrow]{nrow()}} and \code{\link[=ncol]{ncol()}}.
}}

\item{\code{extent}}{Numeric vector with four values (\code{GSpatial} objects, including \code{GRegion}s, \code{GRaster}s, and \code{GVector}s): Extent of the object listed in order from westernmost longitude, easternmost longitude, southernmost latitude, northernmost latitude. Can be obtained using \code{\link[=ext]{ext()}}.}

\item{\code{zextent}}{Numeric (\code{GSpatial} objects, including \code{GRegion}s, \code{GRaster}s, and \code{GVector}s): Bottom- and top-most extents of 3D \code{GRaster}s and \code{GVector}s. Can be obtained using \code{\link[=zext]{zext()}}.}

\item{\code{geometry}}{Character (\code{GVectors}s): Either \code{points}, \code{lines}, or \code{polygons}. Can be obtained using \code{\link[=geomtype]{geomtype()}}.}

\item{\code{nLayers}}{Integer (\code{GRaster}s): Number of layers ("stacked" rasters--different from number of depths of 3D rasters). Can be obtained using \code{\link[=nlyr]{nlyr()}}.}

\item{\code{nGeometries}}{Integer (\code{GVector}s): Number of features (points, lines, or polygons). Can be obtained using \code{\link[=nrow]{nrow()}}.}

\item{\code{datatypeGRASS}}{Character (\code{GRaster}s): Type of data stored in a raster, as interpreted by \code{GRASS}. This is either \code{CELL} (integers), \code{FCELL} (floating-point values), or \code{DCELL} (double-values). Can be obtained using \code{\link[=datatype]{datatype()}}.}

\item{\code{resolution}}{Vector of two numeric values (\code{GRegion}s, including \code{GRaster}s): Size of a raster cell in the east-west direction and in the north-south direction. Can be obtained using \code{\link[=res]{res()}} and \code{\link[=res3d]{res3d()}}.}

\item{\code{minVal,maxVal}}{Numeric (\code{GRaster}s): Minimum and maximum value across all cells. Can be obtained using \code{\link[=minmax]{minmax()}}.}

\item{\code{activeCat}}{Integer (\code{GRaster}s): Column index of the category labels. Must be >0. Note that from the user's standpoint, 1 is subtracted from this number. So a value if \verb{@activeCat} is \code{2}, then the user would see "1" when printed. Can be obtained using \code{\link[=activeCat]{activeCat()}}.}

\item{\code{levels}}{List of \code{data.table}s (\code{GRaster}s): Tables for categorical rasters. If a raster is not categorical, the \code{data.table} is \code{NULL}, as in \code{data.table(NULL)}. Can be obtained using \code{levels()} or \code{cats()}.}

\item{\code{table}}{\code{data.table} (\code{GVector}s): Table with metadata, one row per geometry (point, line, or plane). If no table is associated with the vector, this must be \code{data.table(NULL)}. The column with the category value is given in \verb{@catName}.}

\item{\code{catName}}{Character (\code{GVector}s): Name of the column in the vector's database that contains category values (integers).}
}}

