% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain}
\alias{explain}
\title{Fast approximate Shapley values}
\usage{
explain(
  object,
  feature_names = NULL,
  X,
  nsim = 1,
  pred_wrapper,
  newdata = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted model object (e.g., a 
\code{\link[randomForest]{randomForest}} object).}

\item{feature_names}{Character string giving the names of the predictor
variables (i.e., features) of interest. If \code{NULL} (default) they will be
taken from the column names of \code{X}.}

\item{X}{A matrix-like R object (e.g., a data frame or matrix) containing 
ONLY the feature columns from the training data.}

\item{nsim}{The number of Monte Carlo repetitions to use for estimating each 
Shapley value. Default is 1.}

\item{pred_wrapper}{Prediction function that requires two arguments,
\code{object} and \code{newdata}. The output of this function should be 
determined according to:

\describe{
  \item{Regression}{A numeric vector of predicted outcomes.}
  \item{Binary classification}{A vector of predicted class probabilities
  for the reference class.}
  \item{Multiclass classification}{A vector of predicted class probabilities
  for the reference class.}
}}

\item{newdata}{A matrix-like R object (e.g., a data frame or matrix) 
containing ONLY the feature columns for the observation(s) of interest. 
Default is \code{NULL} which will produce approximate Shapley values for all 
the rows in \code{X}.}

\item{...}{Additional optional arguments to be passed onto
\code{\link[plyr]{laply}}.}
}
\value{
A tibble with one column for each feature specified in 
\code{feature_names} (if \code{feature_names = NULL}, the default, there will
be one column for each feature in \code{X}) and one row for each observation
in \code{newdata} (if \code{newdata = NULL}, the default, there will be one
row for each observation in \code{X}).
}
\description{
Compute fast (approximate) Shapley values for a set of features.
}
\examples{
#
# A projection pursuit regression (PPR) example
#

# Load the sample data; ?datasets::mtcars for details
data(mtcars)

# Fit a projection pursuit regression model
mtcars.ppr <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Compute approximate Shapley values using 10 Monte Carlo simulations
set.seed(101)  # for reproducibility
shap <- explain(mtcars.ppr, X = subset(mtcars, select = -mpg), nsim = 10, 
                pred_wrapper = predict)
shap

# Shapley-based plots
library(ggplot2)
autoplot(shap)  # Shapley-based importance plot
autoplot(shap, type = "dependence", feature = "wt", X = mtcars)
autoplot(shap, type = "contribution", row_num = 1)  # explain first row of X
}
\seealso{
You can find more examples (with larger and more realistic data 
sets) on the \strong{fastshap} GitHub repository: 
\url{https://github.com/bgreenwell/fastshap}.
}
