% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fymd.R
\name{fymd}
\alias{fymd}
\alias{fymd.default}
\alias{fymd.numeric}
\alias{fymd.character}
\title{Construct dates from character and numeric input}
\usage{
fymd(...)

\method{fymd}{default}(...)

\method{fymd}{numeric}(y, m = 1, d = 1, ...)

\method{fymd}{character}(x, strict = FALSE, ...)
}
\arguments{
\item{...}{Arguments to be passed to or from other methods.}

\item{y, m, d}{\code{integerish}.

Numeric vector corresponding to the desired years, months and days.

Double vectors are coerced to integer.

Length 1 vectors will be recycled to the common size across \code{y}, \code{m} and \code{d}.}

\item{x}{\code{character}.

Vector of year-month-date strings in a numeric format (e.g. "2020-02-01").

Parses digits separated by non-digits.

Leading and trailing whitespace will be ignored.}

\item{strict}{\code{bool}.

Should non-whitespace output after a valid date be allowed?

\code{FALSE} (default) will ignore output after a valid date whereas \code{TRUE} will
reject said strings, returning \code{NA}.}
}
\value{
A \code{Date} object
}
\description{
\code{fymd()} is a generic for validated conversion of \R objects to (integer)
\code{Date}. Efficient methods are provided for \code{numeric} and \code{character}
inputs.
}
\details{
The underlying algorithm for both the numeric and character methods follow
the approach described in Hinnant (2021) for calculating days from the
\href{https://en.wikipedia.org/wiki/Unix_time}{UNIX Epoch} from \href{https://en.wikipedia.org/wiki/Gregorian_calendar}{Gregorian Calendar} dates.

The character version parses inputs in a fixed, year, month and day order.
These values must be digits but can be separated by any non-digit character.
It is similar in spirit to that of Simon Urbanek's \link[fasttime:fastPOSIXct]{fastDate()}
implementation in that we use pure text parsing and no system calls.
\code{fymd()} differs from \code{\link[fasttime:fastPOSIXct]{fastDate()}} in that it
validates all dates for correctness and supports a a much larger range of
dates (i.e. the \href{https://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar}{Proleptic Gregorian calendar}.
This additional capability does come with a small performance cost but, IMO,
remains competetive.

For both numeric and character versions years must be in the range
\verb{[-9999, 9999]}.
}
\examples{

cdate     <- "2025-04-16"
timestamp <- "2025-04-16T09:45:53+0000"

# Ignoring the time element
fymd(timestamp)

# This will return NA with a warning
fymd(timestamp, strict = TRUE)

# Checking
as.Date(cdate) == fymd(timestamp)

# Leap year
fymd(2020, 2, 29)

# Not a leap year
fymd(2021, 2, 29)

}
\references{
Hinnant, H. (2021) \emph{chrono-Compatible Low-Level Date Algorithms}.
Available at: \url{https://howardhinnant.github.io/date_algorithms.html#days_from_civil}
(Accessed 17 April 2025).

Urbanek S (2022). \emph{fasttime: Fast Utility Function for Time Parsing
and Conversion}.
R package version 1.1-0, \doi{10.32614/CRAN.package.fasttime}.
}
